/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/08
 */
package org.asyrinx.brownie.tapestry.components.layer;

import java.util.Map;

import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.IRequestCycle;
import org.asyrinx.brownie.core.lang.NumberUtils;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.brownie.tapestry.script.IScriptUser;
import org.asyrinx.brownie.tapestry.script.ScriptWriter;

/**
 * @author akima
 */
public abstract class AbstractLayerComponent
	extends AbstractComponent
	implements IScriptUser {

	/**
	 * @param scriptName
	 */
	protected AbstractLayerComponent(String scriptName) {
		super();
		this.scriptWriter = new ScriptWriter(this, scriptName);
	}

	protected final ScriptWriter scriptWriter;

	/**
	 * @see org.asyrinx.brownie.tapestry.script.AbstractScriptComponent#prepareScriptSymbols(java.util.Map, org.apache.tapestry.IRequestCycle)
	 */
	public void prepareScriptSymbols(Map symbols, IRequestCycle cycle) {

		symbols.put("id", getStyleId());
		symbols.put("left", new Integer(NumberUtils.toInt(getLeft(), 0)));
		symbols.put("top", new Integer(NumberUtils.toInt(getTop(), 0)));
		symbols.put("width", new Integer(NumberUtils.toInt(getWidth(), 0)));
		symbols.put("height", new Integer(NumberUtils.toInt(getHeight(), 0)));
	}

	//			DIV.dsktop {
	//				LEFT:40px; TOP:100px; WIDTH:600px; HEIGHT:600px; CLIP:rect(0px 600px 600px 0px); POSITION:absolute; BACKGROUND-COLOR:#339966; layer-background-color:#339966
	//			}
	public String toStyleValue() {
		final StringBuffer result = new StringBuffer();
		//result.append("DIV.dsktop {");
		addParam(result, "LEFT", this.left, "px");
		addParam(result, "TOP", this.top, "px");
		addParam(result, "WIDTH", this.width, "px");
		addParam(result, "HEIGHT", this.height, "px");
		if (!StringUtils.isEmpty(getWidth())
			&& !StringUtils.isEmpty(getHeight())) {
			result.append("CLIP:rect(");
			result.append("0px ");
			result.append(this.width + "px ");
			result.append(this.height + "px ");
			result.append("0px); ");
		}
		result.append("POSITION:absolute; ");
		addParam(result, "BACKGROUND-COLOR", this.backGroundColor, "");
		addParam(result, "layer-background-color", this.backGroundColor, "");
		//result.append("}");
		return result.toString();
	}

	private void addParam(
		StringBuffer buffer,
		String name,
		String value,
		String suffix) {
		if (StringUtils.isEmpty(value))
			return;
		buffer.append(name + ":" + value + suffix + "; ");
	}

	abstract public String getStyleId();
	abstract public void setStyleId(String string);

	private String left = null;
	private String top = null;
	private String width = null;
	private String height = null;
	private String backGroundColor = null;

	/**
	 * @return
	 */
	public String getHeight() {
		return height;
	}

	/**
	 * @return
	 */
	public String getLeft() {
		return left;
	}

	/**
	 * @return
	 */
	public String getTop() {
		return top;
	}

	/**
	 * @return
	 */
	public String getWidth() {
		return width;
	}

	/**
	 * @param string
	 */
	public void setHeight(String string) {
		height = string;
	}

	/**
	 * @param string
	 */
	public void setLeft(String string) {
		left = string;
	}

	/**
	 * @param string
	 */
	public void setTop(String string) {
		top = string;
	}

	/**
	 * @param string
	 */
	public void setWidth(String string) {
		width = string;
	}

	/**
	 * @return
	 */
	public String getBackGroundColor() {
		return backGroundColor;
	}

	/**
	 * @param string
	 */
	public void setBackGroundColor(String string) {
		backGroundColor = string;
	}

}
