/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/08
 */
package org.asyrinx.brownie.tapestry.components.layer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRender;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.engine.IPageLoader;
import org.apache.tapestry.engine.IPageSource;
import org.apache.tapestry.engine.ITemplateSource;
import org.apache.tapestry.parse.ComponentTemplate;
import org.apache.tapestry.spec.IComponentSpecification;

/**
 * @author akima
 */
public abstract class BaseDesktopComponent extends AbstractDesktopComponent {

	/**
	 * @param scriptName
	 */
	protected BaseDesktopComponent(String scriptName) {
		super(scriptName);
	}

	private static final Log LOG =
		LogFactory.getLog(BaseDesktopComponent.class);

	private static final int OUTER_INIT_SIZE = 5;

	private IRender[] _outer;
	private int _outerCount = 0;

	/**
	 *  Adds an element as an outer element for the receiver.  Outer
	 *  elements are elements that should be directly rendered by the
	 *  receiver's <code>render()</code> method.  That is, they are
	 *  top-level elements on the HTML template.
	 *
	 * 
	 **/

	protected void addOuter(IRender element) {
		if (_outer == null) {
			_outer = new IRender[OUTER_INIT_SIZE];
			_outer[0] = element;
			_outerCount = 1;
			return;
		}
		// No more room?  Make the array bigger.
		if (_outerCount == _outer.length) {
			IRender[] newOuter;
			newOuter = new IRender[_outer.length * 2];
			System.arraycopy(_outer, 0, newOuter, 0, _outerCount);
			_outer = newOuter;
		}
		_outer[_outerCount++] = element;
	}

	/**
	 *
	 *  Reads the receiver's template and figures out which elements wrap which
	 *  other elements.
	 *
	 *  <P>This is coded as a single, big, ugly method for efficiency.
	 * 
	 **/
	private void readTemplate(IRequestCycle cycle, IPageLoader loader) {
		IPageSource pageSource = loader.getEngine().getPageSource();

		if (LOG.isDebugEnabled())
			LOG.debug(this +" reading template");

		ITemplateSource source = loader.getTemplateSource();
		ComponentTemplate componentTemplate = source.getTemplate(cycle, this);

		// Most of the work is done inside the loader class. 
		// We instantiate it just to invoke process() on it.

		new BaseDesktopComponentTemplateLoader(
			cycle,
			loader,
			this,
			componentTemplate,
			pageSource)
			.process();

		if (LOG.isDebugEnabled())
			LOG.debug(this +" finished reading template");
	}

	/**
	 *   Renders the top level components contained by the receiver.
	 *
	 *   @since 2.0.3
	 **/
	protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
		if (LOG.isDebugEnabled())
			LOG.debug("Begin render " + getExtendedId());

		for (int i = 0; i < _outerCount; i++)
			_outer[i].render(writer, cycle);

		if (LOG.isDebugEnabled())
			LOG.debug("End render " + getExtendedId());
	}

	/**
	 *  Loads the template for the component, then invokes
	 *  {@link AbstractComponent#finishLoad(IRequestCycle, IPageLoader, IComponentSpecification))}.  
	 *  Subclasses must invoke this method first,
	 *  before adding any additional behavior, though its usually
	 *  simpler to override {@link #finishLoad()} instead.
	 *
	 **/

	public void finishLoad(
		IRequestCycle cycle,
		IPageLoader loader,
		IComponentSpecification specification) {
		readTemplate(cycle, loader);
		super.finishLoad(cycle, loader, specification);
	}

}
