/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/07
 */
package org.asyrinx.brownie.tapestry.components.layer;

import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;

/**
 * @author akima
 */
public abstract class Desktop extends AbstractLayerComponent {

	/**
	 * @param scriptName
	 */
	public Desktop() {
		super("Desktop.script");
		this.setLeft("0");
		this.setTop(null);
		this.setWidth("400");
		this.setHeight("300");
		this.setBackGroundColor("#339966");
	}

	public static final String ATTRIBUTE_NOW_RENDERING =
		Desktop.class.getName() + ".rendering";

	public static Desktop get(IRequestCycle cycle) {
		return (Desktop) cycle.getAttribute(ATTRIBUTE_NOW_RENDERING);
	}

	/**
	 * @see org.asyrinx.brownie.tapestry.script.AbstractScriptComponent#checkBeforeRender(org.apache.tapestry.IMarkupWriter, org.apache.tapestry.IRequestCycle)
	 */
	protected void checkBeforeRender(
		IMarkupWriter writer,
		IRequestCycle cycle) {
		if (writer == null) {
		}
		if (cycle.getAttribute(ATTRIBUTE_NOW_RENDERING) != null)
			throw new ApplicationRuntimeException(
				"Desktop may not nest",
				this,
				null,
				null);
	}

	/**
	 * 
	 * @see org.apache.tapestry.AbstractComponent#renderComponent(org.apache.tapestry.IMarkupWriter, org.apache.tapestry.IRequestCycle)
	 */
	protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
		checkBeforeRender(writer, cycle);
		cycle.setAttribute(ATTRIBUTE_NOW_RENDERING, this);
		try {
			this.scriptWriter.execute(cycle);

			final IMarkupWriter nested = writer.getNestedWriter();
			renderBody(nested, cycle);

			// Start the div tag.
			writer.println();
			writer.begin("div");
			writer.attribute("id", getStyleId());
			writer.attribute("style", toStyleValue());
			renderInformalParameters(writer, cycle);
			writer.println();
			// Close the nested writer, which dumps its buffered content
			// into its parent.
			nested.close();
			writer.end(); // <div>

		} finally {
			cycle.removeAttribute(ATTRIBUTE_NOW_RENDERING);
		}
	}

}
