/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/04
 */
package org.asyrinx.brownie.tapestry.components.layer;

import java.util.Map;

import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.engine.IPageLoader;
import org.apache.tapestry.spec.IComponentSpecification;
import org.asyrinx.brownie.tapestry.script.IScriptUser;
import org.asyrinx.brownie.tapestry.script.ScriptUsage;
import org.asyrinx.brownie.tapestry.script.ScriptWriter;

/**
 * @author akima
 */
public abstract class OpenCloseSwitch
	extends BaseComponent
	implements IScriptUser {

	/**
	 * @param scriptName
	 */
	public OpenCloseSwitch() {
		super();
		this.scriptWriter = new ScriptWriter(this, "OpenCloseSwitch.script");
		this.scriptWriter.setUsage(ScriptUsage.ONCE_BY_CLASS);
	}

	private final ScriptWriter scriptWriter;

	/**
	 * @see org.apache.tapestry.IComponent#finishLoad(org.apache.tapestry.IRequestCycle, org.apache.tapestry.engine.IPageLoader, org.apache.tapestry.spec.IComponentSpecification)
	 */
	public void finishLoad(
		IRequestCycle cycle,
		IPageLoader loader,
		IComponentSpecification specification) {
		super.finishLoad(cycle, loader, specification);
		this.setOpenImage(getAsset("img_plus"));
		this.setCloseImage(getAsset("img_minus"));
		//this.setOpenImage(null);
		//this.setCloseImage(null);
	}

	/**
	 * @see org.asyrinx.brownie.tapestry.components.layer.AbstractLayerComponent#prepareScriptSymbols(java.util.Map, org.apache.tapestry.IRequestCycle)
	 */
	public void prepareScriptSymbols(Map symbols, IRequestCycle cycle) {
	}

	/**
	 * @see org.apache.tapestry.AbstractComponent#renderComponent(org.apache.tapestry.IMarkupWriter, org.apache.tapestry.IRequestCycle)
	 */
	protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
		this.scriptWriter.execute(cycle);
		super.renderComponent(writer, cycle);
	}

	abstract public boolean isDefaultOpened();
	abstract public void setDefaultOpened(boolean b);

	abstract public String getTargetId();
	abstract public void setTargetId(String string);

	abstract public IAsset getCloseImage();
	abstract public void setCloseImage(IAsset asset);

	abstract public IAsset getOpenImage();
	abstract public void setOpenImage(IAsset asset);

}
