/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/02
 */
package org.asyrinx.brownie.tapestry.components.link;

import java.util.HashMap;
import java.util.Map;

import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IScript;
import org.apache.tapestry.components.ILinkComponent;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.html.Body;
import org.apache.tapestry.link.ILinkRenderer;

/**
 * @author akima
 */
public class LinkRowRenderer extends AbstractLinkRowRenderer {

	public static final ILinkRenderer SHARED_INSTANCE = new LinkRowRenderer();

	/**
	 * 
	 */
	public LinkRowRenderer() {
		super("LinkRowRenderer.script");
	}

	public static final String LINK_URL_DIV_ID = "linkUrl";

	public static final String SYM_LINK_URL_DIV_ID = "linkUrlDivId";
	public static final String SYM_METHOD_CLICK_ROW = "clickLinkRowMethodName";
	public static final String SYM_METHOD_MOSUE_OVER_ROW =
		"mouseOverLinkRowMethodName";
	public static final String SYM_METHOD_MOSUE_OUT_ROW =
		"mouseOutLinkRowMethodName";
	public static final String SYM_SELECT_BG_COLOR = "selectBgColor";
	public static final String SYM_SELECT_STYLE_CLASS = "selectStyleClass";
	public static final String SYM_RENDERER = "renderer";

	/**
	 * @see org.asyrinx.brownie.tapestry.components.link.AbstractScriptLinkRenderer#addScript(org.apache.tapestry.IRequestCycle, org.apache.tapestry.IScript, org.apache.tapestry.html.Body)
	 */
	protected void addScript(IRequestCycle cycle, IScript script, Body body) {
		if (cycle.getAttribute(getScriptId()) != null)
			return;
		cycle.setAttribute(getScriptId(), new int[0]);
		final Map symbols = new HashMap();
		symbols.put(SYM_RENDERER, this);
		symbols.put(SYM_LINK_URL_DIV_ID, LINK_URL_DIV_ID);
		symbols.put(SYM_METHOD_CLICK_ROW, CLICK_LINK_ROW_METHOD_NAME);
		symbols.put(SYM_METHOD_MOSUE_OVER_ROW, MOSUE_OVER_LINK_ROW_METHOD_NAME);
		symbols.put(SYM_METHOD_MOSUE_OUT_ROW, MOSUE_OUT_LINK_ROW_METHOD_NAME);
		symbols.put(SYM_SELECT_BG_COLOR, getSelectBgColor());
		symbols.put(SYM_SELECT_STYLE_CLASS, getSelectStyleClass());
		script.execute(cycle, body, symbols);
	}

	/**
	 * @see org.asyrinx.brownie.tapestry.components.link.AbstractScriptLinkRenderer#renderBody(org.apache.tapestry.IMarkupWriter, org.apache.tapestry.IRequestCycle, org.apache.tapestry.components.ILinkComponent)
	 */
	protected void renderBody(
		IMarkupWriter bodyWriter,
		IRequestCycle cycle,
		ILinkComponent linkComponent) {
		bodyWriter.begin("span");
		bodyWriter.attribute("id", LINK_URL_DIV_ID);
		bodyWriter.attribute("style", "display:none");
		final IMarkupWriter innerDivWriter = bodyWriter.getNestedWriter();
		final ILink l = linkComponent.getLink(cycle);
		innerDivWriter.printRaw(constructURL(l, linkComponent.getAnchor()));
		innerDivWriter.close();
		bodyWriter.end();
		linkComponent.renderBody(bodyWriter, cycle);
	}

	private static final String SCRIPT_ADD_FLAG_KEY =
		DirectLinkRow.class.getName() + ".added.javascript";

	protected String getScriptId() {
		return SCRIPT_ADD_FLAG_KEY + "." + this.hashCode();
	}

}
