/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2003/12/27
 */
package org.asyrinx.brownie.torque.servlet;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.asyrinx.brownie.servlet.FileNameResolver;

/**
 * @author akima
 */
public class TorqueInitFilter implements Filter {

	/**
	 * 
	 */
	public TorqueInitFilter() {
		super();
	}

	/**
	 * @see javax.servlet.Filter#init(javax.servlet.FilterConfig)
	 */
	public void init(FilterConfig config) throws ServletException {
		initTorque(config);
	}

	public static final String CONFIG_KEY_TORQUE = "torque_properties";

	protected void initTorque(FilterConfig config) throws ServletException {
		final String configPath = config.getInitParameter(CONFIG_KEY_TORQUE);
		final ServletContext context = config.getServletContext();
		final FileNameResolver resolver = new FileNameResolver(context);
		String actualPath = resolver.toRealPath(configPath);
		if (StringUtils.isEmpty(actualPath))
			actualPath = configPath;
		try {
			Torque.init(actualPath);
			context.log("Torque was initialized");
		} catch (TorqueException e) {
			throw new ServletException(e);
		}
	}
	/**
	 * @see javax.servlet.Filter#doFilter(javax.servlet.ServletRequest, javax.servlet.ServletResponse, javax.servlet.FilterChain)
	 */
	public void doFilter(
		ServletRequest req,
		ServletResponse res,
		FilterChain filterChain)
		throws IOException, ServletException {
		filterChain.doFilter(req, res);
	}

	/**
	 * @see javax.servlet.Filter#destroy()
	 */
	public void destroy() {
	}

}
