/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/28
 */
package test.org.asyrinx.brownie.core.collection;

import java.util.List;

import org.asyrinx.brownie.core.collection.QueueList;

import junit.framework.TestCase;

/**
 * @author akima
 */
public class QueueListTest extends TestCase {

	/**
	 * Constructor for QueueListTest.
	 * @param name
	 */
	public QueueListTest(String name) {
		super(name);
	}

	public static void main(String[] args) {
		junit.swingui.TestRunner.run(QueueListTest.class);
	}

	/*
	 * Test for boolean add(Object)
	 */
	public void testAddObject() {
		final List queue = new QueueList(3);
		queue.add("0");
		assertEquals(1, queue.size());
		queue.add("1");
		assertEquals(2, queue.size());
		queue.add("2");
		assertEquals(3, queue.size());
		queue.add("3");
		assertEquals(3, queue.size());
		assertEquals("1", queue.get(0));
		assertEquals("2", queue.get(1));
		assertEquals("3", queue.get(2));
		queue.add("4");
		assertEquals(3, queue.size());
		assertEquals("2", queue.get(0));
		assertEquals("3", queue.get(1));
		assertEquals("4", queue.get(2));
		queue.add("5");
		assertEquals(3, queue.size());
		assertEquals("3", queue.get(0));
		assertEquals("4", queue.get(1));
		assertEquals("5", queue.get(2));
	}

}
