/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package test.org.asyrinx.brownie.core.util;

import java.util.Date;

import junit.framework.TestCase;

import org.asyrinx.brownie.core.util.DateRange;

/**
 * @author akima
 */
public class DateRangeTest extends TestCase {

	/**
	 * Constructor for DateRangeTest.
	 * @param arg0
	 */
	public DateRangeTest(String arg0) {
		super(arg0);
	}

	public static void main(String[] args) {
		junit.swingui.TestRunner.run(DateRangeTest.class);
	}

	public void testEquals() {
		final long nowMiliSec = System.currentTimeMillis();
		final Date now1 = new Date(nowMiliSec);
		final Date now2 = new Date(nowMiliSec);
		final DateRange range1 = new DateRange(null, null);
		final DateRange range2 = new DateRange(null, now1);
		final DateRange range3 = new DateRange(now1, null);
		final DateRange range4 = new DateRange(now1, now1);

		final DateRange range5 = new DateRange(null, null);
		final DateRange range6 = new DateRange(null, now2);
		final DateRange range7 = new DateRange(now2, null);
		final DateRange range8 = new DateRange(now2, now2);

		assertEquals(range1, range5);
		assertEquals(range2, range6);
		assertEquals(range3, range7);
		assertEquals(range4, range8);

		assertTrue(range1 != range2);
		assertTrue(range1 != range3);
		assertTrue(range1 != range4);
	}

	public void testInclude() {
		final long nowMiliSec = System.currentTimeMillis();
		final Date d1 = new Date(nowMiliSec - 100);
		final Date d2 = new Date(nowMiliSec);
		final Date d3 = new Date(nowMiliSec + 100);

		final DateRange range1 = new DateRange(d1, d3);
		assertTrue(!range1.include(d1));
		assertTrue(range1.include(d2));
		assertTrue(!range1.include(d3));
		final DateRange range2 = new DateRange(d1, d2);
		assertTrue(!range2.include(d1));
		assertTrue(!range2.include(d2));
		assertTrue(!range2.include(d3));
	}

}
