/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
package test.org.asyrinx.brownie.core.util.jp;

import junit.framework.TestCase;

import org.asyrinx.brownie.core.util.MathUtils;

/**
 * @author akima
 */
public class MathUtilsTest extends TestCase {

	/**
	 * Constructor for MathUtilsTest.
	 * @param name
	 */
	public MathUtilsTest(String name) {
		super(name);
	}

	public static void main(String[] args) {
		junit.swingui.TestRunner.run(MathUtilsTest.class);
	}

	public void testDigitPlace() {
		assertEquals(1, MathUtils.digitPlace(0));
		assertEquals(1, MathUtils.digitPlace(1));
		assertEquals(1, MathUtils.digitPlace(2));
		assertEquals(1, MathUtils.digitPlace(9));
		assertEquals(2, MathUtils.digitPlace(10));
		assertEquals(3, MathUtils.digitPlace(100));
		assertEquals(3, MathUtils.digitPlace(999));
		assertEquals(8, MathUtils.digitPlace(99999999));
		assertEquals(19, MathUtils.digitPlace(999999999999999999l));
		assertEquals(19, MathUtils.digitPlace(1000000000000000000l));
		assertEquals(1, MathUtils.digitPlace(-1));
		assertEquals(1, MathUtils.digitPlace(-2));
		assertEquals(1, MathUtils.digitPlace(-9));
		assertEquals(2, MathUtils.digitPlace(-10));
		assertEquals(3, MathUtils.digitPlace(-100));
		assertEquals(3, MathUtils.digitPlace(-999));
		assertEquals(8, MathUtils.digitPlace(-99999999));
		assertEquals(19, MathUtils.digitPlace(-999999999999999999l));
		assertEquals(19, MathUtils.digitPlace(-1000000000000000000l));
	}

	public void testGetDigitAt() {
		assertEquals(1, MathUtils.getDigitAt(987654321, 1));
		assertEquals(2, MathUtils.getDigitAt(987654321, 2));
		assertEquals(3, MathUtils.getDigitAt(987654321, 3));
		assertEquals(4, MathUtils.getDigitAt(987654321, 4));
		assertEquals(5, MathUtils.getDigitAt(987654321, 5));
		assertEquals(6, MathUtils.getDigitAt(987654321, 6));
		assertEquals(7, MathUtils.getDigitAt(987654321, 7));
		assertEquals(8, MathUtils.getDigitAt(987654321, 8));
		assertEquals(9, MathUtils.getDigitAt(987654321, 9));

		assertEquals(1, MathUtils.getDigitAt(987654321.123456, -1));
		assertEquals(2, MathUtils.getDigitAt(987654321.123456, -2));
		assertEquals(3, MathUtils.getDigitAt(987654321.123456, -3));
		assertEquals(4, MathUtils.getDigitAt(987654321.123456, -4));
		assertEquals(5, MathUtils.getDigitAt(987654321.123456, -5));
		assertEquals(6, MathUtils.getDigitAt(987654321.123456, -6));
	}

}
