/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/04
 */
package test.org.asyrinx.brownie.tapestry.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;

import junit.framework.TestCase;

import org.apache.commons.collections.SequencedHashMap;
import org.apache.tapestry.html.HTMLWriter;
import org.asyrinx.brownie.core.collection.MapTree;
import org.asyrinx.brownie.tapestry.util.ValueTagWriter;

/**
 * @author akima
 */
public class ValueTagWriterTest extends TestCase {

	/**
	 * Constructor for ValueTagWriterTest.
	 * @param name
	 */
	public ValueTagWriterTest(String name) {
		super(name);
	}

	public static void main(String[] args) {
		junit.swingui.TestRunner.run(ValueTagWriterTest.class);
	}

	public void testAddProperty() {
		final OutputStream outputStream = new ByteArrayOutputStream(10000);
		final HTMLWriter htmlWriter = new HTMLWriter(outputStream);
		final ValueTagWriter tagWriter = new ValueTagWriter(htmlWriter);
		tagWriter.addProperty("a", "1");
		htmlWriter.close();
		System.out.println(outputStream.toString());
		assertEquals("<span id=\"a\">1</span>", outputStream.toString());
	}

	public void testAddProperties() {
		final MapTree mapTree = new MapTree(new SequencedHashMap()) {
			protected Map createMap() {
				return new SequencedHashMap();
			}
		};
		mapTree.put("a.b.c", "123");
		mapTree.put("a.b.d", "124");
		mapTree.put("a.e.c", "153");
		mapTree.put("f.b.d", "624");

		final OutputStream outputStream = new ByteArrayOutputStream(10000);
		final HTMLWriter htmlWriter = new HTMLWriter(outputStream);
		final ValueTagWriter tagWriter = new ValueTagWriter(htmlWriter);
		tagWriter.addProperties(mapTree.getRoot());
		htmlWriter.close();
		final String expected =
			"<span id=\"a\">"
				+ "<span id=\"b\">"
				+ "<span id=\"c\">123</span>"
				+ "<span id=\"d\">124</span>"
				+ "</span>"
				+ "<span id=\"e\">"
				+ "<span id=\"c\">153</span>"
				+ "</span>"
				+ "</span>"
				+ "<span id=\"f\">"
				+ "<span id=\"b\">"
				+ "<span id=\"d\">624</span>"
				+ "</span>"
				+ "</span>";
		System.out.println(expected);
		System.out.println(outputStream.toString());
		assertEquals(expected, outputStream.toString());
	}

}
