/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.io.sf;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.asyrinx.brownie.core.io.FileNameUtils;
import org.asyrinx.brownie.core.io.sf.AbstractFileStreamFactory;

public class DirectoryBaseFileStreamFactory
extends AbstractFileStreamFactory {
    private final String baseDirectory;

    public DirectoryBaseFileStreamFactory(String baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    public String toFilePath(String virtualFileName) {
        virtualFileName = FileNameUtils.replaceSeparatorSlash(virtualFileName);
        return FileNameUtils.toAbsolutePath(this.baseDirectory, virtualFileName);
    }

    public InputStream newInput(String fileName) throws IOException {
        return new FileInputStream(this.toFilePath(fileName));
    }

    public OutputStream newOutput(String fileName) throws IOException {
        return new FileOutputStream(this.toFilePath(fileName));
    }

    public String getBaseDirectory() {
        return this.baseDirectory;
    }
}

