/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.log;

import org.apache.commons.logging.LogFactory;
import org.asyrinx.brownie.core.lang.ClassUtils;
import org.asyrinx.brownie.core.log.DispatchLog;

public class CascadeNamedLog
extends DispatchLog {
    private String loggerName;
    private static final char DEFAULT_SUB_LOG_NAME_DELIMITER = '.';
    private char subLogNameDelimiter = (char)46;

    public CascadeNamedLog(String loggerName) {
        super(LogFactory.getLog((String)loggerName));
        this.loggerName = loggerName;
    }

    public CascadeNamedLog(Class class1) {
        this(class1.getName());
    }

    public CascadeNamedLog(String loggerName, String defaultLevel) {
        super(LogFactory.getLog((String)loggerName), defaultLevel);
        this.loggerName = loggerName;
    }

    public CascadeNamedLog(Class class1, String defaultLevel) {
        this(class1.getName(), defaultLevel);
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
        super.setLog(LogFactory.getLog((String)loggerName));
    }

    public char getSubLogNameDelimiter() {
        return this.subLogNameDelimiter;
    }

    public void setSubLogNameDelimiter(char c) {
        this.subLogNameDelimiter = c;
    }

    public CascadeNamedLog subLog(String subName) {
        return new CascadeNamedLog(String.valueOf(this.getLoggerName()) + this.getSubLogNameDelimiter() + subName, this.getDefaultLevel());
    }

    public CascadeNamedLog subLog(Object object) {
        return this.subLog(object.getClass());
    }

    public CascadeNamedLog subLog(Class class1) {
        return this.subLogByShortClassName(class1);
    }

    public CascadeNamedLog subLogByShortClassName(Class class1) {
        return this.subLog(ClassUtils.toShortClassName(class1));
    }

    public CascadeNamedLog subLogByFullClassName(Class class1) {
        return this.subLog(class1.getName());
    }
}

