/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.log;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.asyrinx.brownie.core.log.LogLevel;
import org.asyrinx.brownie.core.log.MeasureLog;

public class MeasureLogImpl
implements MeasureLog {
    private final Log log;
    private final LogLevel level;
    private final String caption;
    private long startedTime = 0L;

    public MeasureLogImpl(String caption) {
        this(caption, null);
    }

    public MeasureLogImpl(String caption, Log log) {
        this(caption, log, (LogLevel)null);
    }

    public MeasureLogImpl(String caption, Log log, String level) {
        this(caption, log, LogLevel.findByName(level));
    }

    public MeasureLogImpl(String caption, Log log, LogLevel level) {
        this.caption = caption;
        if (log == null) {
            log = LogFactory.getLog(this.getClass());
        }
        if (level == null) {
            level = LogLevel.DEBUG;
        }
        this.level = level;
        this.log = log;
    }

    public void reset() {
        this.startedTime = System.currentTimeMillis();
    }

    public void done(String message) {
        StringBuffer msg = new StringBuffer();
        msg.append("[measure");
        msg.append(":");
        msg.append(this.caption);
        msg.append("] ");
        msg.append(message);
        msg.append(" -- ");
        msg.append(String.valueOf(System.currentTimeMillis() - this.startedTime));
        this.level.write(this.log, msg.toString());
    }
}

