/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.jdbc.logger;

import java.sql.Connection;
import java.sql.SQLException;
import org.asyrinx.brownie.core.log.CascadeNamedLog;
import org.asyrinx.brownie.jdbc.logger.LogConnectionFilter;
import org.asyrinx.brownie.jdbc.wrapper.DataSourceWrapper;

public class LogDataSource
extends DataSourceWrapper {
    private final CascadeNamedLog log = new CascadeNamedLog(this.getClass(), "debug");

    public Connection getConnection() throws SQLException {
        return this.toLogConnection(super.getConnection());
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.toLogConnection(super.getConnection(username, password));
    }

    protected Connection toLogConnection(Connection connection) {
        return LogConnectionFilter.log(connection, this.log);
    }

    public String getDefaultLevel() {
        return this.log.getDefaultLevel();
    }

    public String getLoggerName() {
        return this.log.getLoggerName();
    }

    public void setDefaultLevel(String string) {
        this.log.setDefaultLevel(string);
    }

    public void setLoggerName(String loggerName) {
        this.log.setLoggerName(loggerName);
    }
}

