/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/03/06
 */
package org.asyrinx.brownie.torque.util;

import java.util.HashMap;
import java.util.Map;

import org.apache.torque.util.Criteria;
import org.asyrinx.brownie.core.sql.Operator;

/**
 * @author akima
 */
public class SqlEnumUtils {

	public static Object toSqlEnum(Object object) {
		//if (object instanceof SqlEnum)
		if ("org.apache.torque.util.SqlEnum"
			.equals(object.getClass().getName()))
			return object;
		else if (object instanceof String)
			return toSqlEnum((String) object);
		else if (object instanceof Operator)
			return toSqlEnum(object.toString());
		return null;
	}

	public static Object toSqlEnum(String string) {
		return getStrToEnumMap().get(string);
	}

	private static Map strToEnumMap = null;
	private static Map getStrToEnumMap() {
		if (strToEnumMap != null)
			return strToEnumMap;
		strToEnumMap = new HashMap();
		strToEnumMap.put("=", Criteria.EQUAL);
		strToEnumMap.put("!=", Criteria.NOT_EQUAL);
		strToEnumMap.put("<>", Criteria.NOT_EQUAL);
		strToEnumMap.put(">", Criteria.GREATER_THAN);
		strToEnumMap.put("=>", Criteria.GREATER_EQUAL);
		strToEnumMap.put(">=", Criteria.GREATER_EQUAL);
		strToEnumMap.put("<", Criteria.LESS_THAN);
		strToEnumMap.put("=<", Criteria.LESS_EQUAL);
		strToEnumMap.put("<=", Criteria.LESS_EQUAL);
		strToEnumMap.put("like", Criteria.LIKE);
		strToEnumMap.put("LIKE", Criteria.LIKE);
		strToEnumMap.put("not like", Criteria.NOT_LIKE);
		strToEnumMap.put("NOT LIKE", Criteria.NOT_LIKE);
		strToEnumMap.put("in", Criteria.IN);
		strToEnumMap.put("IN", Criteria.IN);
		strToEnumMap.put("not in", Criteria.NOT_IN);
		strToEnumMap.put("NOT IN", Criteria.NOT_IN);
		return strToEnumMap;
	}

}
