/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/19
 */
package org.asyrinx.joey.om.hibernate;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;

import org.apache.commons.lang.exception.NestableRuntimeException;
import org.asyrinx.brownie.core.sql.Operator;
import org.asyrinx.brownie.core.sql2.Select;
import org.asyrinx.joey.om.ConditionTranslator;
import org.asyrinx.joey.om.SearchCondition;

/**
 * @author akima
 */
public class HqlTranslator
	extends AbstractHibernateTranslator
	implements ConditionTranslator {

	/**
	 * 
	 */
	public HqlTranslator(Map columnToProperty, Map tableToClass) {
		super(columnToProperty, tableToClass);
	}

	protected final Select dynamicSelect = new Select();

	/**
	 * @see org.asyrinx.joey.om.ConditionTranslater#addFrom(java.lang.String)
	 */
	public void addFrom(String tableName) {
		tableName = toClass(tableName);
		dynamicSelect.getFromTables().add(tableName);
	}

	/**
	 * @see org.asyrinx.joey.om.ConditionTranslater#addAscendingOrderByColumn(java.lang.String)
	 */
	public void addAscendingOrderByColumn(String fieldName) {
		fieldName = toFieldName(fieldName);
		dynamicSelect.getOrderByFields().add(fieldName);
	}

	/**
	 * @see org.asyrinx.joey.om.ConditionTranslater#addDate(java.lang.String, java.lang.String, java.lang.Object, java.text.DateFormat)
	 */
	public void addDate(
		String fieldName,
		Object value,
		Object operator,
		DateFormat dateFormat) {
		fieldName = toFieldName(fieldName);
		try {
			final Date d =
				(value instanceof Date)
					? (Date) value
					: dateFormat.parse(String.valueOf(value));
			dynamicSelect.getWhereConditions().add(
				fieldName,
				d,
				Operator.get(operator));
		} catch (ParseException e) {
			throw new NestableRuntimeException(e);
		}
	}

	/**
	 * @see org.asyrinx.joey.om.ConditionTranslater#addDescendingOrderByColumn(java.lang.String)
	 */
	public void addDescendingOrderByColumn(String fieldName) {
		fieldName = toFieldName(fieldName);
		dynamicSelect.getOrderByFields().add(fieldName + " desc");
	}

	/**
	 * @see org.asyrinx.joey.om.ConditionTranslater#addInt(java.lang.String, java.lang.String, java.lang.Object)
	 */
	public void addInt(String fieldName, Object value, Object operator) {
		fieldName = toFieldName(fieldName);
		final Object val = toNumber(value, Integer.class);
		if (val == null)
			return;
		dynamicSelect.getWhereConditions().add(
			fieldName,
			val,
			Operator.get(operator));
	}

	/**
	 * @see org.asyrinx.joey.om.ConditionTranslater#addLong(java.lang.String, java.lang.String, java.lang.Object)
	 */
	public void addLong(String fieldName, Object value, Object operator) {
		fieldName = toFieldName(fieldName);
		final Object val = toNumber(value, Long.class);
		if (val == null)
			return;
		dynamicSelect.getWhereConditions().add(
			fieldName,
			val,
			Operator.get(operator));
	}

	/**
	 * @see org.asyrinx.joey.om.ConditionTranslater#addString(java.lang.String, java.lang.String, java.lang.Object)
	 */
	public void addString(String fieldName, Object value, Object operator) {
		fieldName = toFieldName(fieldName);
		dynamicSelect.getWhereConditions().add(
			fieldName,
			value,
			Operator.get(operator));
	}

	public String toHQL(SearchCondition condition) {
		condition.attach(this);
		final String result = dynamicSelect.toSql();
		log.info(result);
		return result;
	}

}
