/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/23
 */
package org.asyrinx.joey.spring.dao.hibernate;

import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;

import net.sf.hibernate.HibernateException;

import org.asyrinx.brownie.jdbc.util.JdbcServerService;
import org.asyrinx.brownie.jdbc.util.JdbcServerServiceImpl;
import org.asyrinx.joey.om.SearchCondition;
import org.asyrinx.joey.spring.dao.JoeyBaseDao;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.hibernate.support.HibernateDaoSupport;

/**
 * @author akima
 */
public abstract class BaseHibernateDao
	extends HibernateDaoSupport
	implements JoeyBaseDao {

	/**
	 * 
	 */
	public BaseHibernateDao() {
		super();
	}

	abstract public List select(SearchCondition condition);

	private JdbcServerService serverService = null;

	/**
	 * @return
	 */
	public JdbcServerService getJdbcServerService() {
		if (serverService == null) {
			try {
				serverService =
					new JdbcServerServiceImpl(getSession().connection());
			} catch (HibernateException e) {
				throw new DataAccessResourceFailureException(
					"failed to retrieve JDBC server service.",
					e);
			}
		}
		return serverService;
	}

	/**
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Date getCurrentDate() {
		try {
			return getJdbcServerService().getCurrentDate();
		} catch (SQLException e) {
			throw new DataAccessResourceFailureException(
				"failed to retrieve JDBC server's current date.",
				e);
		}
	}

	/**
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Time getCurrentTime() {
		try {
			return getJdbcServerService().getCurrentTime();
		} catch (SQLException e) {
			throw new DataAccessResourceFailureException(
				"failed to retrieve JDBC server's current date.",
				e);
		}
	}

	/**
	 * @return
	 * @throws java.sql.SQLException
	 */
	public Timestamp getCurrentTimestamp() {
		try {
			return getJdbcServerService().getCurrentTimestamp();
		} catch (SQLException e) {
			throw new DataAccessResourceFailureException(
				"failed to retrieve JDBC server's current date.",
				e);
		}
	}

	/**
	 * @see org.asyrinx.joey.spring.dao.JoeyBaseDao#getCurrentTimestampAsDate()
	 */
	public Date getCurrentTimestampAsDate() {
		return new Date(getCurrentTimestamp().getTime());
	}

}
