/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/12
 */
package org.asyrinx.joey.tapestry.components.stative;

import java.io.Serializable;
import java.util.Stack;

import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.asyrinx.brownie.core.user.IUser;
import org.asyrinx.joey.om.SearchCondition;

/**
 * @author akima
 */
public class BaseVisit implements Serializable {

	/**
	 * 
	 */
	public BaseVisit() {
		super();
	}

	private IUser loginUser = null;

	private boolean requestDebug = false;
	private boolean disableInspector = false;

	public boolean isUserLogined() {
		return loginUser != null;
	}

	public String getLoginUserDisplayName() {
		return (loginUser != null) ? loginUser.getDisplayName() : "";
	}

	public void setRequestDebug(boolean value) {
		this.requestDebug = value;
	}

	public boolean getRequestDebug() {
		return requestDebug;
	}

	public boolean getDisableInspector() {
		return disableInspector;
	}

	public void setDisableInspector(boolean disableInspector) {
		this.disableInspector = disableInspector;
	}

	private final Stack accessHistories = new Stack();

	class AccessObject implements Serializable {
		public AccessObject(String pageName, Object object) {
			super();
			this.pageName = pageName;
			this.object = object;
		}
		final String pageName;
		final Object object;
	}

	public void saveLastAccessPage(IPage page) {
		if (page == null)
			return;
		final Object object;
		if (page instanceof BaseEditPage) {
			final BaseEditPage editPage = (BaseEditPage) page;
			object = editPage.getEditObject();
		} else {
			final BaseListPage listPage = (BaseListPage) page;
			object = listPage.getWayToSearch();
		}
		accessHistories.push(new AccessObject(page.getPageName(), object));
	}

	public void goBackToLastAccessPage(IRequestCycle cycle) {
		if (accessHistories.isEmpty())
			return;
		AccessObject accessObject = (AccessObject) accessHistories.pop();
		final IPage page = cycle.getPage(accessObject.pageName);
		if (page == null)
			return;
		if (page instanceof BaseEditPage) {
			final BaseEditPage editPage = (BaseEditPage) page;
			editPage.setEditObject(accessObject.object);
		} else {
			final BaseListPage listPage = (BaseListPage) page;
			if (accessObject.object instanceof SearchCondition)
				listPage.setWayToSearch((SearchCondition) accessObject.object);
			listPage.search(cycle);
		}
		cycle.activate(page);
	}

	/**
	 * @return
	 */
	public IUser getLoginUser() {
		return loginUser;
	}

	/**
	 * @param user
	 */
	public void setLoginUser(IUser user) {
		loginUser = user;
	}

}
