/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/19
 */
package org.asyrinx.joey.tapestry.engine;

import java.util.Map;

import org.apache.tapestry.engine.BaseEngine;
import org.apache.tapestry.request.RequestContext;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/**
 * @author akima
 */
public class SpringAppEngine extends BaseEngine {

	public static final String APPLICATION_CONTEXT_KEY = "appContext";

	/**
	 * @see org.apache.tapestry.engine.AbstractEngine#setupForRequest(org.apache.tapestry.request.RequestContext)
	 */
	protected void setupForRequest(RequestContext context) {
		super.setupForRequest(context);

		// insert ApplicationContext in global, if not there
		final Map global = (Map) getGlobal();
		ApplicationContext ac =
			(ApplicationContext) global.get(APPLICATION_CONTEXT_KEY);
		if (ac == null) {
			ac =
				WebApplicationContextUtils.getWebApplicationContext(
					context.getServlet().getServletContext());
			global.put(APPLICATION_CONTEXT_KEY, ac);
		}
	}
}
