/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/03/02
 */
package test.org.asyrinx.joey.om.hibernate;

import java.util.HashMap;
import java.util.Map;

import org.asyrinx.brownie.core.lang.enum.ValuedEnum;
import org.asyrinx.brownie.core.lang.enum.ValuedEnumSet;
import org.asyrinx.brownie.core.sql.Operator;
import org.asyrinx.joey.om.AbstractSearchCondition;
import org.asyrinx.joey.om.hibernate.HqlTranslator;

import junit.framework.TestCase;

/**
 * @author akima
 */
public class HqlTranslatorTest extends TestCase {

	/**
	 * Constructor for HqlTranslatorTest.
	 * @param name
	 */
	public HqlTranslatorTest(String name) {
		super(name);
	}

	public static void main(String[] args) {
		junit.swingui.TestRunner.run(HqlTranslatorTest.class);
	}

	public void testToHQL() {
		final TestCondition condition = new TestCondition();
		condition.setIntValueMax("999");
		condition.getIntEnumSet().getEntryByName("int1").setSelected(true);
		condition.getIntEnumSet().getEntryByName("int3").setSelected(true);
		final HqlTranslator translator =
			new HqlTranslator(new HashMap(), getTableMap());
		final String hql = translator.toHQL(condition);
		System.out.println(hql);
		assertEquals(
			"from testTable where intValue <= 999 and intEnum in (1, 3)",
			hql);
	}

	private Map getTableMap() {
		final Map result = new HashMap();
		result.put("testTable", "testTable");
		return result;
	}

}
class TestCondition extends AbstractSearchCondition {

	private String intValueMin;
	private String intValueMax;

	private String stringValue;

	private ValuedEnumSet intEnumSet =
		new ValuedEnumSet(TestIntValuedEnum.class);
	private ValuedEnumSet stringEnumSet =
		new ValuedEnumSet(TestStringValuedEnum.class);

	/**
	 * @see org.asyrinx.joey.om.AbstractSearchCondition#prepare()
	 */
	protected void prepare() {
		addFrom("testTable");
		addIntMin("intValue", intValueMin);
		addIntMax("intValue", intValueMax);
		addIntMax("stringValue", stringValue);
		addInt("intEnum", intEnumSet.getSelectedEnumValues(), Operator.IN);
		addString(
			"stringEnum",
			stringEnumSet.getSelectedEnumValues(),
			Operator.IN);
	}

	/**
	 * @return
	 */
	public ValuedEnumSet getIntEnumSet() {
		return intEnumSet;
	}

	/**
	 * @return
	 */
	public String getIntValueMax() {
		return intValueMax;
	}

	/**
	 * @return
	 */
	public String getIntValueMin() {
		return intValueMin;
	}

	/**
	 * @return
	 */
	public ValuedEnumSet getStringEnumSet() {
		return stringEnumSet;
	}

	/**
	 * @return
	 */
	public String getStringValue() {
		return stringValue;
	}

	/**
	 * @param set
	 */
	public void setIntEnumSet(ValuedEnumSet set) {
		intEnumSet = set;
	}

	/**
	 * @param string
	 */
	public void setIntValueMax(String string) {
		intValueMax = string;
	}

	/**
	 * @param string
	 */
	public void setIntValueMin(String string) {
		intValueMin = string;
	}

	/**
	 * @param set
	 */
	public void setStringEnumSet(ValuedEnumSet set) {
		stringEnumSet = set;
	}

	/**
	 * @param string
	 */
	public void setStringValue(String string) {
		stringValue = string;
	}

}
class TestIntValuedEnum extends ValuedEnum {
	/**
	 * @param name
	 * @param value
	 */
	public TestIntValuedEnum(String name, int value) {
		super(name, new Integer(value));
	}

	public static final TestIntValuedEnum VALUE_1 =
		new TestIntValuedEnum("int1", 1);
	public static final TestIntValuedEnum VALUE_2 =
		new TestIntValuedEnum("int2", 2);
	public static final TestIntValuedEnum VALUE_3 =
		new TestIntValuedEnum("int3", 3);
}
class TestStringValuedEnum extends ValuedEnum {
	/**
	 * @param name
	 * @param value
	 */
	public TestStringValuedEnum(String name, String value) {
		super(name, value);
	}

	public static final TestStringValuedEnum VALUE_1 =
		new TestStringValuedEnum("stringA", "aaa");
	public static final TestStringValuedEnum VALUE_2 =
		new TestStringValuedEnum("stringB", "bbb");
	public static final TestStringValuedEnum VALUE_3 =
		new TestStringValuedEnum("stringC", "ccc");
}
