/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.spring.dao.hibernate;

import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import net.sf.hibernate.HibernateException;
import org.asyrinx.brownie.jdbc.util.JdbcServerService;
import org.asyrinx.brownie.jdbc.util.JdbcServerServiceImpl;
import org.asyrinx.joey.om.SearchCondition;
import org.asyrinx.joey.spring.dao.JoeyBaseDao;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.hibernate.support.HibernateDaoSupport;

public abstract class BaseHibernateDao
extends HibernateDaoSupport
implements JoeyBaseDao {
    private JdbcServerService serverService = null;

    public abstract List select(SearchCondition var1);

    public JdbcServerService getJdbcServerService() {
        if (this.serverService == null) {
            try {
                this.serverService = new JdbcServerServiceImpl(this.getSession().connection());
            }
            catch (HibernateException e) {
                throw new DataAccessResourceFailureException("failed to retrieve JDBC server service.", (Throwable)e);
            }
        }
        return this.serverService;
    }

    public Date getCurrentDate() {
        try {
            return this.getJdbcServerService().getCurrentDate();
        }
        catch (SQLException e) {
            throw new DataAccessResourceFailureException("failed to retrieve JDBC server's current date.", (Throwable)e);
        }
    }

    public Time getCurrentTime() {
        try {
            return this.getJdbcServerService().getCurrentTime();
        }
        catch (SQLException e) {
            throw new DataAccessResourceFailureException("failed to retrieve JDBC server's current date.", (Throwable)e);
        }
    }

    public Timestamp getCurrentTimestamp() {
        try {
            return this.getJdbcServerService().getCurrentTimestamp();
        }
        catch (SQLException e) {
            throw new DataAccessResourceFailureException("failed to retrieve JDBC server's current date.", (Throwable)e);
        }
    }

    public Date getCurrentTimestampAsDate() {
        return new Date(this.getCurrentTimestamp().getTime());
    }
}

