/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/27
 */
package org.asyrinx.joey.gen.model;

import java.util.HashMap;
import java.util.Map;

import org.apache.torque.engine.database.model.TypeMap;

/**
 * -------------------------------------------------------
 * SQL Type      | Java Type            | Hibernate Type
 * -------------------------------------------------------
 * CHAR          | String               | character
 * VARCHAR       | String               | string
 * LONGVARCHAR   | String               | string
 * NUMERIC       | java.math.BigDecimal | big_decimal
 * DECIMAL       | java.math.BigDecimal | big_decimal
 * BIT           | boolean OR Boolean   | boolean
 * TINYINT       | byte OR Byte         | byte
 * SMALLINT      | short OR Short       | short
 * INTEGER       | int OR Integer       | integer
 * BIGINT        | long OR Long         | long
 * REAL          | float OR Float       | float
 * FLOAT         | double OR Double     | double
 * DOUBLE        | double OR Double     | double
 * BINARY        | byte[]               | binary
 * VARBINARY     | byte[]               | binary
 * LONGVARBINARY | byte[]               | binary
 * DATE          | java.sql.Date        | date
 * TIME          | java.sql.Time        | time
 * TIMESTAMP     | java.sql.Timestamp   | timestamp
 * BLOB			 | java.sql.Blob        | blob
 * CLOB			 | java.sql.Clob        | clob
 * NULL
 * OTHER
 * JAVA_OBJECT
 * DISTINCT
 * STRUCT
 * ARRAY
 * REF
 * BOOLEANINT
 * BOOLEANCHAR
 *  * @author akima
 */
public class TypeNameUtils extends TypeMap {

	/**
	 * 
	 */
	public TypeNameUtils() {
		super();
	}

	/**
	 * @param torqueType
	 * @return
	 */
	public static String toJavaNativeType(String torqueType) {
		return TypeMap.getJavaNative(TypeMap.getJdbcType(torqueType));
	}

	public static String toClassName(String primitiveTypeName) {
		final String result =
			(String) mapJavaPrimitiveToClass.get(primitiveTypeName);
		if (result != null)
			return result;
		else
			return primitiveTypeName;
	}

	public static String torqueToHibernateType(String torqueType) {
		return (String) mapTorqueToHibernateType.get(torqueType);
	}

	private static Map mapTorqueToHibernateType = newMapTorqueToHibernateType();
	private static synchronized final Map newMapTorqueToHibernateType() {
		final Map result = new HashMap();
		result.put("CHAR", "character");
		result.put("VARCHAR", "string");
		result.put("LONGVARCHAR", "string");
		result.put("NUMERIC", "big_decimal");
		result.put("DECIMAL", "big_decimal");
		result.put("BIT", "boolean");
		result.put("TINYINT", "byte");
		result.put("SMALLINT", "short");
		result.put("INTEGER", "integer");
		result.put("BIGINT", "long");
		result.put("REAL", "float");
		result.put("FLOAT", "double");
		result.put("DOUBLE", "double");
		result.put("BINARY", "binary");
		result.put("VARBINARY", "binary");
		result.put("LONGVARBINARY", "binary");
		result.put("DATE", "date");
		result.put("TIME", "time");
		result.put("TIMESTAMP", "timestamp");
		result.put("BLOB", "blob");
		result.put("CLOB", "clob");
		return result;
	}

	private static Map mapJavaPrimitiveToClass = newJavaTypeMap();
	private static synchronized final Map newJavaTypeMap() {
		final Map result = new HashMap();
		result.put(BIT_NATIVE_TYPE, BIT_JAVA_CLASS);
		result.put(TINYINT_NATIVE_TYPE, TINYINT_JAVA_CLASS);
		result.put(SMALLINT_NATIVE_TYPE, SMALLINT_JAVA_CLASS);
		result.put(INTEGER_NATIVE_TYPE, INTEGER_JAVA_CLASS);
		result.put(BIGINT_NATIVE_TYPE, BIGINT_JAVA_CLASS);
		result.put(REAL_NATIVE_TYPE, REAL_JAVA_CLASS);
		result.put(FLOAT_NATIVE_TYPE, FLOAT_JAVA_CLASS);
		result.put(DOUBLE_NATIVE_TYPE, DOUBLE_JAVA_CLASS);
		result.put(BINARY_NATIVE_TYPE, BINARY_JAVA_CLASS);
		result.put(VARBINARY_NATIVE_TYPE, VARBINARY_JAVA_CLASS);
		result.put(LONGVARBINARY_NATIVE_TYPE, LONGVARBINARY_JAVA_CLASS);
		result.put(BLOB_NATIVE_TYPE, BLOB_JAVA_CLASS);
		result.put(BOOLEANCHAR_NATIVE_TYPE, BOOLEANCHAR_JAVA_CLASS);
		result.put(BOOLEANINT_NATIVE_TYPE, BOOLEANINT_JAVA_CLASS);
		return result;
	}

	private static final String BIT_NATIVE_TYPE = "boolean";
	private static final String TINYINT_NATIVE_TYPE = "byte";
	private static final String SMALLINT_NATIVE_TYPE = "short";
	private static final String INTEGER_NATIVE_TYPE = "int";
	private static final String BIGINT_NATIVE_TYPE = "long";
	private static final String REAL_NATIVE_TYPE = "float";
	private static final String FLOAT_NATIVE_TYPE = "double";
	private static final String DOUBLE_NATIVE_TYPE = "double";
	private static final String BINARY_NATIVE_TYPE = "byte[]";
	private static final String VARBINARY_NATIVE_TYPE = "byte[]";
	private static final String LONGVARBINARY_NATIVE_TYPE = "byte[]";
	private static final String BLOB_NATIVE_TYPE = "byte[]";
	private static final String BOOLEANCHAR_NATIVE_TYPE = "boolean";
	private static final String BOOLEANINT_NATIVE_TYPE = "boolean";

	private static final String BIT_JAVA_CLASS = "Boolean";
	private static final String TINYINT_JAVA_CLASS = "Byte";
	private static final String SMALLINT_JAVA_CLASS = "Short";
	private static final String INTEGER_JAVA_CLASS = "Integer";
	private static final String BIGINT_JAVA_CLASS = "Long";
	private static final String REAL_JAVA_CLASS = "Float";
	private static final String FLOAT_JAVA_CLASS = "Double";
	private static final String DOUBLE_JAVA_CLASS = "Double";
	private static final String BINARY_JAVA_CLASS = "Byte[]";
	private static final String VARBINARY_JAVA_CLASS = "Byte[]";
	private static final String LONGVARBINARY_JAVA_CLASS = "Byte[]";
	private static final String BLOB_JAVA_CLASS = "Byte[]";
	private static final String BOOLEANCHAR_JAVA_CLASS = "Boolean";
	private static final String BOOLEANINT_JAVA_CLASS = "Boolean";

}
