/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/27
 */
package org.asyrinx.joey.gen.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.apache.torque.engine.database.model.AppData;
import org.apache.torque.engine.database.model.Database;
import org.asyrinx.brownie.core.lang.ObjectUtils;

/**
 * @author akima
 */
public class WmAppData extends AppData implements IElement {

	/**
	 * @param databaseType
	 * @param basePropsFilePath
	 */
	public WmAppData(String databaseType, String basePropsFilePath) {
		super(databaseType, basePropsFilePath);
	}

	public void accept(IVisitor visitor) {
		visitor.visit(this);
	}

	/**
	 * @see org.apache.torque.engine.database.model.AppData#toString()
	 */
	public String toString() {
		return ObjectUtils.identityToString(this);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IElement#finishLoad()
	 */
	public void finishLoad() {
	}

	private final List databaseList = new ArrayList();

	/**
	 * @see org.apache.torque.engine.database.model.AppData#addDatabase(org.apache.torque.engine.database.model.Database)
	 */
	public void addDatabase(Database db) {
		super.addDatabase(db);
		databaseList.add(db);
	}

	public Iterator getDbIterator() {
		return databaseList.iterator();
	}

	public WmDatabase find(String databaseName) {
		if (StringUtils.isEmpty(databaseName))
			return null;
		final Iterator iterator = getDbIterator();
		while (iterator.hasNext()) {
			final WmDatabase db = (WmDatabase) iterator.next();
			if (databaseName.equals(db.getName()))
				return db;
		}
		return null;
	}

}
