/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/27
 */
package org.asyrinx.joey.gen.model;

import java.util.ArrayList;
import java.util.List;

/**
 * @author akima
 */
public class WmAspect implements IElement{

	/**
	 * 
	 */
	public WmAspect() {
		super();
	}

	public void accept(IVisitor visitor) {
		visitor.visit(this);
	}
	
	/**
	 * @see org.asyrinx.brownie.windmill.model.IElement#finishLoad()
	 */
	public void finishLoad() {
	}


	private WmDatabase database = null;
	private final List actions = new ArrayList();

	/**
	 * @see org.apache.torque.engine.database.model.Table#addUnique(org.xml.sax.Attributes)
	 */
	public void addAction(WmAspectAction action) {
		action.setAspect(this);
		actions.add(action);
	}

	public List getActions() {
		return actions;
	}

	private String name = null;
	private String where = null;

	/**
	 * @return
	 */
	public WmDatabase getDatabase() {
		return database;
	}

	/**
	 * @return
	 */
	public String getName() {
		return name;
	}

	/**
	 * @return
	 */
	public String getWhere() {
		return where;
	}

	/**
	 * @param database
	 */
	public void setDatabase(WmDatabase database) {
		this.database = database;
	}

	/**
	 * @param string
	 */
	public void setName(String string) {
		name = string;
	}

	/**
	 * @param string
	 */
	public void setWhere(String string) {
		where = string;
	}

}
