/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/27
 */
package org.asyrinx.joey.gen.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.Column;
import org.apache.torque.engine.database.model.Database;
import org.apache.torque.engine.database.model.ForeignKey;
import org.apache.torque.engine.database.model.Table;
import org.apache.torque.engine.database.model.TypeMap;

/**
 * @author akima
 */
public class WmColumn
	extends Column
	implements Cloneable, IProperty, IFieldType, IElement {

	/**
	 * 
	 */
	public WmColumn() {
		super();
	}

	private final FieldTypeImpl fieldTypeImpl = new FieldTypeImpl(this);

	/**
	 * @param name
	 */
	public WmColumn(String name) {
		super(name);
	}

	public void accept(IVisitor visitor) {
		visitor.visit(this);
	}
	/**
	 * @see org.apache.torque.engine.database.model.Column#toString()
	 */
	public String toString() {
		return ObjectUtils.identityToString(this);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IElement#finishLoad()
	 */
	public void finishLoad() {
		if (getJavaNamingMethod() == null)
			setJavaNamingMethod(
				getTable().getDatabase().getDefaultJavaNamingMethod());
		if (isPrimaryKey())
			setNotNull(true);
	}

	/**
	 * @see java.lang.Object#clone()
	 */
	public Object clone() throws CloneNotSupportedException {
		WmColumn result = (WmColumn) super.clone();
		if (this.additional != null)
			result.addProperty((WmProperty) this.additional.clone());
		if (this.format != null)
			result.setFormat((WmColumnFormat) this.format.clone());
		return result;
	}
	/**
	 * @see org.apache.torque.engine.database.model.Table#addUnique(org.xml.sax.Attributes)
	 */
	public void addProperty(WmProperty property) {
		property.setColumn(this);
		additional = property;
	}

	final Log log = LogFactory.getLog(this.getClass());

	/**
	 * @see org.apache.torque.engine.database.model.Column#setTable(org.apache.torque.engine.database.model.Table)
	 */
	public void setTable(Table parent) {
		super.setTable(parent);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IProperty#getEnum()
	 */
	public WmEnum getEnum() {
		return null;
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IProperty#getBelongForeignKey()
	 */
	public List getBelongForeignKeys() {
		final List result = new ArrayList();
		final Table localTable = this.getTable();
		final Iterator fkIter =
			IteratorUtils.arrayIterator(localTable.getForeignKeys());
		while (fkIter.hasNext()) {
			final ForeignKey fk = (ForeignKey) fkIter.next();
			final Iterator localColNameIter = fk.getLocalColumns().iterator();
			while (localColNameIter.hasNext()) {
				final String localColName = (String) localColNameIter.next();
				final Column localCol = localTable.getColumn(localColName);
				if (localCol == this)
					result.add(fk);
			}
		}
		return result;
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IProperty#getBelongForeignKey()
	 */
	public WmColumn getForeignColumn(WmForeignKey foreignKey) {
		final Table localTable = this.getTable();
		final Database database = localTable.getDatabase();
		final Table foreignTable =
			database.getTable(foreignKey.getForeignTableName());
		final Map localForeignNameMap = foreignKey.getLocalForeignMapping();
		final Iterator localColNameIter =
			foreignKey.getLocalColumns().iterator();
		while (localColNameIter.hasNext()) {
			final String localColName = (String) localColNameIter.next();
			final Column localCol = localTable.getColumn(localColName);
			final String foreignColName =
				String.valueOf(localForeignNameMap.get(localColName));
			final Column foreignCol = foreignTable.getColumn(foreignColName);
			if (localCol == this)
				return (WmColumn) foreignCol;
		}
		return null;
	}

	public String getJavaClass() {
		return TypeNameUtils.toClassName(getJavaNativeType());
	}

	public String getJavaNativeType() {
		return TypeMap.getJavaNative(
			TypeMap.getJdbcType(String.valueOf(getTorqueType())));
	}

	private WmProperty additional = null;

	/**
	 * @see org.apache.torque.engine.database.model.Column#getType()
	 */
	public Object getType() {
		return super.getType();
	}
	public void setType(Object type) {
		super.setType(String.valueOf(type));
	}

	public String getDefaultValueString() {
		String value = getDefaultValue();
		if (StringUtils.isEmpty(value))
			return "";
		if (StringUtils.equalsIgnoreCase(value, "null"))
			return "null";
		final String javaType = getJavaNativeType();

		if ("boolean".equals(javaType) || "Boolean".equals(javaType)) {
			if ("1".equals(value) || "Y".equalsIgnoreCase(value))
				value = "true";
			else if ("0".equals(value) || "n".equalsIgnoreCase(value))
				value = "false";
		}

		if ("String".equals(javaType))
			return "\"" + value + "\"";
		else if ("BigDecimal".equals(javaType))
			return "new BigDecimal(" + value + ")";
		else if ("NumberKey".equals(javaType))
			return "new NumberKey(\"" + value + "\")";
		else if ("StringKey".equals(javaType))
			return "new StringKey(\"" + value + "\")";
		else if (!isPrimitive())
			return "new " + javaType + "(" + value + ")";
		else
			return value;
	}

	private String javaNamingMethod = null;
	private boolean inheritance = false;

	private boolean visible = true;
	private boolean readonly = false;
	private String label = null;
	private boolean isLoginName = false;
	private WmColumnFormat format = null;

	/**
	 * @return
	 */
	public String getLabel() {
		if (StringUtils.isEmpty(label))
			return this.getName();
		else
			return label;
	}

	/**
	 * @return
	 */
	public boolean isLoginName() {
		return isLoginName;
	}

	/**
	 * @return
	 */
	public boolean isReadonly() {
		return readonly;
	}

	/**
	 * @return
	 */
	public boolean isVisible() {
		return visible;
	}

	/**
	 * @param b
	 */
	public void setLoginName(boolean b) {
		isLoginName = b;
	}

	/**
	 * @param b
	 */
	public void setReadonly(boolean b) {
		readonly = b;
	}

	/**
	 * @param b
	 */
	public void setVisible(boolean b) {
		visible = b;
	}

	/**
	 * @param string
	 */
	public void setLabel(String string) {
		label = string;
	}

	/**
	 * @return
	 */
	public WmProperty getAdditional() {
		return additional;
	}

	/**
	 * @param property
	 */
	public void setAdditional(WmProperty property) {
		additional = property;
	}

	/**
	 * @return
	 */
	public boolean isRequired() {
		return isNotNull();
	}

	/**
	 * @param b
	 */
	public void setRequired(boolean b) {
		setNotNull(b);
	}

	/**
	 * @return
	 */
	public WmColumnFormat getFormat() {
		return format;
	}

	/**
	 * @param format
	 */
	public void setFormat(WmColumnFormat format) {
		this.format = format;
		format.setColumn(this);
	}

	/**
	 * @return
	 */
	public boolean isBooleanFieldType() {
		return fieldTypeImpl.isBooleanFieldType();
	}

	/**
	 * @return
	 */
	public boolean isDateFieldType() {
		return fieldTypeImpl.isDateFieldType();
	}

	/**
	 * @return
	 */
	public boolean isMemoFieldType() {
		return fieldTypeImpl.isMemoFieldType();
	}

	/**
	 * @return
	 */
	public boolean isNumberFieldType() {
		return fieldTypeImpl.isNumberFieldType();
	}

	/**
	 * @return
	 */
	public boolean isSelectFieldType() {
		return fieldTypeImpl.isSelectFieldType();
	}

	/**
	 * @return
	 */
	public boolean isTextFieldType() {
		return fieldTypeImpl.isTextFieldType();
	}

	/**
	 * @return
	 */
	public String getJavaNamingMethod() {
		return javaNamingMethod;
	}

	/**
	 * @param string
	 */
	public void setJavaNamingMethod(String string) {
		javaNamingMethod = string;
	}

	/**
	 * @return
	 */
	public boolean isInheritance() {
		return inheritance;
	}

	/**
	 * @param b
	 */
	public void setInheritance(boolean b) {
		inheritance = b;
	}

}
