/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/27
 */
package org.asyrinx.joey.gen.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.Database;
import org.apache.torque.engine.database.model.NameGenerator;

/**
 * @author akima
 */
public class WmDatabase extends Database implements IElement {

	/**
	 * 
	 */
	public WmDatabase() {
		super();
	}

	public void accept(IVisitor visitor) {
		visitor.visit(this);
	}

	/**
	 * @see org.apache.torque.engine.database.model.Database#toString()
	 */
	public String toString() {
		return ObjectUtils.identityToString(this);
	}

	public void finishLoad() {
		if (getDefaultJavaNamingMethod() == null)
			setDefaultJavaNamingMethod(NameGenerator.CONV_METHOD_UNDERSCORE);
	}

	private String defaultJavaType;

	private final List aspects = new ArrayList();

	public void addAspect(WmAspect aspect) {
		aspect.setDatabase(this);
		aspects.add(aspect);
	}

	public List getAspects() {
		return aspects;
	}

	public WmAspect findAspect(String name) {
		if (StringUtils.isEmpty(name))
			return null;
		final Iterator iterator = aspects.iterator();
		while (iterator.hasNext()) {
			WmAspect aspect = (WmAspect) iterator.next();
			if (name.equals(aspect.getName()))
				return aspect;
		}
		return null;
	}

	private final List tableAspects = new ArrayList();

	public void addTableAspect(WmTableAspect tableAspect) {
		tableAspect.setDatabase(this);
		tableAspects.add(tableAspect);
	}

	public List getTableAspects() {
		return tableAspects;
	}

	private final List enums = new ArrayList();

	public void addEnum(WmEnum enum) {
		enum.setDatabase(this);
		enums.add(enum);
	}

	public List getEnums() {
		return enums;
	}

	public WmEnum findEnum(String name) {
		if (StringUtils.isEmpty(name))
			return null;
		final Iterator iterator = this.enums.iterator();
		while (iterator.hasNext()) {
			final WmEnum enum = (WmEnum) iterator.next();
			if (name.equals(enum.getName()))
				return enum;
		}
		return null;
	}

	Log log = LogFactory.getLog(this.getClass());

	/**
	 * @see org.apache.torque.engine.database.model.Database#getDefaultIdMethod()
	 */
	public String getDefaultIdMethod() {
		return super.getDefaultIdMethod();
	}

	/**
	 * @see org.apache.torque.engine.database.model.Database#setDefaultIdMethod(java.lang.String)
	 */
	public void setDefaultIdMethod(String v) {
		log.debug("setDefaultIdMethod was called: " + v);
		super.setDefaultIdMethod(v);
	}

	/**
	 * @return
	 */
	public String getDefaultJavaType() {
		return defaultJavaType;
	}

	/**
	 * @param string
	 */
	public void setDefaultJavaType(String string) {
		defaultJavaType = string;
	}

}
