/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/29
 */
package org.asyrinx.joey.gen.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.lang.StringUtils;

/**
 * @author akima
 */
public class WmJoin implements Cloneable, IElement {

	/**
	 * 
	 */
	public WmJoin() {
		super();
	}

	public void accept(IVisitor visitor) {
		visitor.visit(this);
	}
	/**
	 * @see java.lang.Object#clone()
	 */
	public Object clone() throws CloneNotSupportedException {
		final WmJoin result = (WmJoin) super.clone();
		final Iterator iterator = children.iterator();
		while (iterator.hasNext()) {
			final WmJoin child = (WmJoin) iterator.next();
			result.addJoin((WmJoin) child.clone());
		}
		return result;
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IElement#finishLoad()
	 */
	public void finishLoad() {
	}

	private WmTable parentTable = null;
	private WmJoin parent = null;
	private List children = new ArrayList();

	public void addJoin(WmJoin join) {
		join.setParent(this);
		children.add(join);
	}

	public WmTable getOwnerTable() {
		if (getParentTable() != null)
			return getParentTable();
		else if (getParent() != null)
			return getParent().getOwnerTable();
		else
			return null;
	}

	public WmTable getTargetTable() {
		return (WmTable) getOwnerTable().getDatabase().getTable(
			this.getTable());
	}

	public WmTable getLocalTable() {
		if (getParent() != null)
			return getParent().getTargetTable();
		else
			return this.getParentTable();
	}

	public WmForeignKey getTargetForeignKey() {
		final WmTable fkOwner;
		if (TYPE_ONE_TO_ONE.equals(this.getType())) {
			fkOwner = getLocalTable();
		} else if (TYPE_ONE_TO_MANY.equals(this.getType())) {
			fkOwner = getTargetTable();
		} else {
			throw new RuntimeException("Illegal type: " + getType());
		}
		return fkOwner.findForeignKey(this.getForeignKey());
	}

	public boolean needToShow(IProperty property) {
		final WmForeignKey fk = getTargetForeignKey();
		final List colList;
		if (TYPE_ONE_TO_ONE.equals(this.getType())) {
			colList = fk.getForeignColumns();
		} else if (TYPE_ONE_TO_MANY.equals(this.getType())) {
			colList = fk.getLocalColumns();
		} else {
			throw new RuntimeException("Illegal type: " + getType());
		}
		if (property instanceof WmColumn)
			return !colList.contains(property.getName());
		else if (property instanceof WmProperty)
			return !colList.contains(
				((WmProperty) property).getColumn().getName());
		else
			throw new RuntimeException(
				"Illegal class: "
					+ property.getName()
					+ "("
					+ property.getClass().getName()
					+ ")");
	}

	public String getBeanName() {
		final WmForeignKey foreignKey = getTargetForeignKey();
		if (TYPE_ONE_TO_ONE.equals(this.getType())) {
			return foreignKey.getPropertyNameInLocal();
		} else if (TYPE_ONE_TO_MANY.equals(this.getType())) {
			return foreignKey.getPropertyNameInReferred();
		} else {
			throw new RuntimeException("Illegal type: " + getType());
		}
	}

	public String getBeanNameCapitalized() {
		return StringUtils.capitalize(getBeanName());
	}

	public String getChainedBeanName() {
		return getChainedBeanName(".");
	}

	public String getChainedBeanName(String separator) {
		if (getParent() != null) {
			return getParent().getChainedBeanName(separator)
				+ separator
				+ getBeanName();
		} else {
			return getBeanName();
		}
	}

	public String getChainedBeanNameFromMany() {
		return getChainedBeanNameFromMany(".");
	}

	public String getChainedBeanNameFromMany(String separator) {
		if (TYPE_ONE_TO_MANY.equals(this.getType())) {
			return "";
		} else if (getParent() != null) {
			if (TYPE_ONE_TO_ONE.equals(getParent().getType())) {
				return getParent().getChainedBeanNameFromMany(separator)
					+ separator
					+ getBeanName();
			} else {
				return getBeanName();
			}
		} else {
			return getBeanName();
		}
	}

	public WmJoin getAncestorOneToMany() {
		if (getParent() != null) {
			if (TYPE_ONE_TO_MANY.equals(getParent().getType()))
				return getParent();
			else
				return getParent().getAncestorOneToMany();
		} else {
			return null;
		}
	}

	public boolean isAncestorOfOneToMany() {
		final Iterator iterator = getChildren().iterator();
		while (iterator.hasNext()) {
			WmJoin child = (WmJoin) iterator.next();
			if (TYPE_ONE_TO_MANY.equals(child.getType()))
				return true;
			if (child.isAncestorOfOneToMany())
				return true;
		}
		return false;
	}

	public static final String TYPE_ONE_TO_ONE = "oneToOne";
	public static final String TYPE_ONE_TO_MANY = "oneToMany";

	private String type;
	private String table;
	private String foreignKey;

	/**
	 * @return
	 */
	public List getChildren() {
		return children;
	}

	/**
	 * @return
	 */
	public String getForeignKey() {
		return foreignKey;
	}

	/**
	 * @return
	 */
	public WmJoin getParent() {
		return parent;
	}

	/**
	 * @return
	 */
	public String getTable() {
		return table;
	}

	/**
	 * @param list
	 */
	public void setChildren(List list) {
		children = list;
	}

	/**
	 * @param string
	 */
	public void setForeignKey(String string) {
		foreignKey = string;
	}

	/**
	 * @param join
	 */
	public void setParent(WmJoin join) {
		parent = join;
	}

	/**
	 * @param string
	 */
	public void setTable(String string) {
		table = string;
	}

	/**
	 * @return
	 */
	public String getType() {
		return type;
	}

	/**
	 * @param string
	 */
	public void setType(String string) {
		type = string;
	}

	/**
	 * @return
	 */
	public WmTable getParentTable() {
		return parentTable;
	}

	/**
	 * @param table
	 */
	public void setParentTable(WmTable table) {
		parentTable = table;
	}

}
