/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/27
 */
package org.asyrinx.joey.gen.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.apache.torque.engine.database.model.Database;
import org.apache.torque.engine.database.model.Table;

/**
 * @author akima
 */
public class WmProperty implements Cloneable, IProperty, IFieldType, IElement {

	/**
	 * 
	 */
	public WmProperty() {
		super();
	}

	private final FieldTypeImpl fieldTypeImpl = new FieldTypeImpl(this);

	public void accept(IVisitor visitor) {
		visitor.visit(this);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IElement#finishLoad()
	 */
	public void finishLoad() {
	}

	/**
	 * @see java.lang.Object#clone()
	 */
	public Object clone() throws CloneNotSupportedException {
		final WmProperty result = (WmProperty) super.clone();
		if (this.format != null)
			result.setFormat((WmColumnFormat) this.format.clone());
		return result;
	}

	private WmColumn column = null;

	public boolean isEnumProperty() {
		return ((WmDatabase) getColumn().getTable().getDatabase()).findEnum(
			this.getJavaType())
			!= null;
	}

	public WmEnum getEnum() {
		return ((WmDatabase) getColumn().getTable().getDatabase()).findEnum(
			this.getJavaType());
	}

	private static final Map typeToTorqueType = newTypeToTorqueType();

	private static Map newTypeToTorqueType() {
		final Map result = new HashMap();
		result.put("String", "VARCHAR");
		result.put("Date", "DATE");
		result.put("boolean", "BIT");
		result.put("byte", "TINYINT");
		result.put("short", "SMALLINT");
		result.put("int", "INTEGER");
		result.put("long", "BIGINT");
		result.put("float", "REAL");
		result.put("double", "DOUBLE");
		result.put("byte[]", "BLOB");
		return result;
	}

	/**
	 * Returns the column type as given in the schema as an object
	 */
	public Object getTorqueType() {
		if (getEnum() != null)
			return "custom enum(" + getEnum().getName() + ")";
		return typeToTorqueType.get(this.type);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IProperty#getBelongForeignKeys()
	 */
	public List getBelongForeignKeys() {
		return this.column.getBelongForeignKeys();
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IProperty#getForeignColumn(org.asyrinx.brownie.windmill.model.WmForeignKey)
	 */
	public WmColumn getForeignColumn(WmForeignKey foreignKey) {
		if (StringUtils.isEmpty(this.foreignProperty))
			return null;
		final Table localTable = ((WmTable) getColumn().getTable());
		final Database database = localTable.getDatabase();
		final Table foreignTable =
			database.getTable(foreignKey.getForeignTableName());
		return (WmColumn) foreignTable.getColumn(this.foreignProperty);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IProperty#isPrimaryKey()
	 */
	public boolean isPrimaryKey() {
		return false;
	}

	public String getJavaClass() {
		return TypeNameUtils.toClassName(this.getJavaType());
	}

	private String valueToGet = null;
	private String foreignProperty = null;

	private boolean visible = true;
	private boolean readonly = false;
	private String label = null;

	private String name;
	private String description;
	private String type;

	private WmColumnFormat format = null;

	/**
	 * @return
	 */
	public String getLabel() {
		if (StringUtils.isEmpty(label))
			return this.getName();
		else
			return label;
	}

	/**
	 * @return
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * @return
	 */
	public String getForeignProperty() {
		return foreignProperty;
	}

	/**
	 * @return
	 */
	public String getJavaName() {
		return name;
	}

	/**
	 * @return
	 */
	public String getJavaType() {
		return type;
	}

	/**
	 * @return
	 */
	public String getName() {
		return name;
	}

	/**
	 * @return
	 */
	public boolean isReadonly() {
		return readonly;
	}

	/**
	 * @return
	 */
	public String getValueToGet() {
		return valueToGet;
	}

	/**
	 * @return
	 */
	public boolean isVisible() {
		return visible;
	}

	/**
	 * @param string
	 */
	public void setDescription(String string) {
		description = string;
	}

	/**
	 * @param string
	 */
	public void setForeignProperty(String string) {
		foreignProperty = string;
	}

	/**
	 * @param string
	 */
	public void setJavaName(String string) {
		name = string;
	}

	/**
	 * @param string
	 */
	public void setJavaType(String string) {
		type = string;
	}

	/**
	 * @param string
	 */
	public void setLabel(String string) {
		label = string;
	}

	/**
	 * @param string
	 */
	public void setName(String string) {
		name = string;
	}

	/**
	 * @param b
	 */
	public void setReadonly(boolean b) {
		readonly = b;
	}

	/**
	 * @param string
	 */
	public void setValueToGet(String string) {
		valueToGet = string;
	}

	/**
	 * @param b
	 */
	public void setVisible(boolean b) {
		visible = b;
	}

	/**
	 * @return
	 */
	public WmColumn getColumn() {
		return column;
	}

	/**
	 * @param column
	 */
	public void setColumn(WmColumn column) {
		this.column = column;
	}

	/**
	 * @return
	 */
	public String getType() {
		return type;
	}

	/**
	 * @param string
	 */
	public void setType(String string) {
		type = string;
	}

	/**
	 * @return
	 */
	public WmColumnFormat getFormat() {
		return format;
	}

	/**
	 * @param format
	 */
	public void setFormat(WmColumnFormat format) {
		this.format = format;
	}

	/**
	 * @return
	 */
	public boolean isBooleanFieldType() {
		return fieldTypeImpl.isBooleanFieldType();
	}

	/**
	 * @return
	 */
	public boolean isDateFieldType() {
		return fieldTypeImpl.isDateFieldType();
	}

	/**
	 * @return
	 */
	public boolean isMemoFieldType() {
		return fieldTypeImpl.isMemoFieldType();
	}

	/**
	 * @return
	 */
	public boolean isNumberFieldType() {
		return fieldTypeImpl.isNumberFieldType();
	}

	/**
	 * @return
	 */
	public boolean isSelectFieldType() {
		return fieldTypeImpl.isSelectFieldType();
	}

	/**
	 * @return
	 */
	public boolean isTextFieldType() {
		return fieldTypeImpl.isTextFieldType();
	}

}
