/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/29
 */
package org.asyrinx.joey.gen.model.visitor;

import java.io.IOException;
import java.io.Writer;

import org.apache.commons.lang.exception.NestableRuntimeException;
import org.asyrinx.brownie.core.lang.ObjectUtils;

/**
 * @author akima
 */
public class DescibeVisitor extends CommonVisitor {

	/**
	 * 
	 */
	public DescibeVisitor(Writer writer) {
		super();
		this.writer = writer;
	}

	final Writer writer;

	/**
	 * @see org.asyrinx.brownie.windmill.model.CommonVisitor#visitCommon(java.lang.Object)
	 */
	protected void visitCommon(Object object) {
		try {
			writer.write(ObjectUtils.describeProperties(object));
			writer.write("\n");
		} catch (IOException e) {
			throw new NestableRuntimeException(e);
		}
	}

}
