/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/29
 */
package org.asyrinx.joey.gen.model.visitor;

import java.util.Iterator;

import org.apache.commons.collections.IteratorUtils;
import org.asyrinx.joey.gen.model.IVisitor;
import org.asyrinx.joey.gen.model.WmAppData;
import org.asyrinx.joey.gen.model.WmAspect;
import org.asyrinx.joey.gen.model.WmAspectAction;
import org.asyrinx.joey.gen.model.WmAspectRef;
import org.asyrinx.joey.gen.model.WmColumn;
import org.asyrinx.joey.gen.model.WmColumnFormat;
import org.asyrinx.joey.gen.model.WmDatabase;
import org.asyrinx.joey.gen.model.WmEnum;
import org.asyrinx.joey.gen.model.WmEnumEntry;
import org.asyrinx.joey.gen.model.WmForeignKey;
import org.asyrinx.joey.gen.model.WmIdMethodParameter;
import org.asyrinx.joey.gen.model.WmIndex;
import org.asyrinx.joey.gen.model.WmInheritance;
import org.asyrinx.joey.gen.model.WmJoin;
import org.asyrinx.joey.gen.model.WmProperty;
import org.asyrinx.joey.gen.model.WmTable;
import org.asyrinx.joey.gen.model.WmTableAspect;
import org.asyrinx.joey.gen.model.WmUnique;

/**
 * @author akima
 */
public class TopDownVisitor extends VisitorWrapper {

	/**
	 * @param wrapped
	 */
	public TopDownVisitor(IVisitor wrapped) {
		super(wrapped);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmAppData)
	 */
	public void visit(WmAppData appData) {
		super.visit(appData);
		final Iterator iterator = appData.getDbIterator();
		while (iterator.hasNext()) {
			WmDatabase database = (WmDatabase) iterator.next();
			database.accept(this);
		}
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmAspect)
	 */
	public void visit(WmAspect aspect) {
		super.visit(aspect);
		final Iterator iterator = aspect.getActions().iterator();
		while (iterator.hasNext()) {
			WmAspectAction action = (WmAspectAction) iterator.next();
			action.accept(this);
		}
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmAspectAction)
	 */
	public void visit(WmAspectAction aspectAction) {
		super.visit(aspectAction);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmAspectRef)
	 */
	public void visit(WmAspectRef aspectRef) {
		super.visit(aspectRef);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmColumn)
	 */
	public void visit(WmColumn column) {
		super.visit(column);
		if (column.getAdditional() != null)
			column.getAdditional().accept(this);
		if (column.getFormat() != null)
			column.getFormat().accept(this);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.visitor.VisitorWrapper#visit(org.asyrinx.brownie.windmill.model.WmColumnFormat)
	 */
	public void visit(WmColumnFormat format) {
		super.visit(format);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmDatabase)
	 */
	public void visit(WmDatabase database) {
		super.visit(database);
		final Iterator tableIter =
			IteratorUtils.arrayIterator(database.getTables());
		while (tableIter.hasNext()) {
			WmTable table = (WmTable) tableIter.next();
			table.accept(this);
		}
		final Iterator tableAspectIter = database.getTableAspects().iterator();
		while (tableAspectIter.hasNext()) {
			WmTableAspect tableAspect = (WmTableAspect) tableAspectIter.next();
			tableAspect.accept(this);
		}
		final Iterator aspectIter = database.getAspects().iterator();
		while (aspectIter.hasNext()) {
			WmAspect aspect = (WmAspect) aspectIter.next();
			aspect.accept(this);
		}
		final Iterator enumIter = database.getEnums().iterator();
		while (enumIter.hasNext()) {
			WmEnum enum = (WmEnum) enumIter.next();
			enum.accept(this);
		}
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmEnum)
	 */
	public void visit(WmEnum enum) {
		super.visit(enum);
		final Iterator iterator = enum.getEntries().iterator();
		while (iterator.hasNext()) {
			WmEnumEntry entry = (WmEnumEntry) iterator.next();
			entry.accept(this);
		}
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmEnumEntry)
	 */
	public void visit(WmEnumEntry enumEntry) {
		super.visit(enumEntry);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmForeignKey)
	 */
	public void visit(WmForeignKey foreignKey) {
		super.visit(foreignKey);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmIdMethodParameter)
	 */
	public void visit(WmIdMethodParameter idMethodParameter) {
		super.visit(idMethodParameter);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmIndex)
	 */
	public void visit(WmIndex index) {
		super.visit(index);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmInheritance)
	 */
	public void visit(WmInheritance inheritance) {
		super.visit(inheritance);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmJoin)
	 */
	public void visit(WmJoin join) {
		super.visit(join);
		final Iterator iterator = join.getChildren().iterator();
		while (iterator.hasNext()) {
			WmJoin child = (WmJoin) iterator.next();
			child.accept(this);
		}
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmProperty)
	 */
	public void visit(WmProperty property) {
		super.visit(property);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmTable)
	 */
	public void visit(WmTable table) {
		super.visit(table);
		visitTableImpl(table);
	}

	private void visitTableImpl(WmTable table) {
		final Iterator colIter =
			IteratorUtils.arrayIterator(table.getColumns());
		while (colIter.hasNext()) {
			WmColumn col = (WmColumn) colIter.next();
			col.accept(this);
		}
		final Iterator fkIter =
			IteratorUtils.arrayIterator(table.getForeignKeys());
		while (fkIter.hasNext()) {
			WmForeignKey foreignKey = (WmForeignKey) fkIter.next();
			foreignKey.accept(this);
		}
		final Iterator idxIter =
			IteratorUtils.arrayIterator(table.getIndices());
		while (idxIter.hasNext()) {
			WmIndex index = (WmIndex) idxIter.next();
			index.accept(this);
		}
		final Iterator uniqIter =
			IteratorUtils.arrayIterator(table.getUnices());
		while (uniqIter.hasNext()) {
			WmUnique unique = (WmUnique) uniqIter.next();
			unique.accept(this);
		}
		if (table.getIdMethodParameters() != null) {
			final Iterator idMethodIter =
				table.getIdMethodParameters().iterator();
			while (idMethodIter.hasNext()) {
				WmIdMethodParameter parameter =
					(WmIdMethodParameter) idMethodIter.next();
				parameter.accept(this);
			}
		}
		final Iterator refIter = table.getAspectRefs().iterator();
		while (refIter.hasNext()) {
			WmAspectRef aspectRef = (WmAspectRef) refIter.next();
			aspectRef.accept(this);
		}
		final Iterator joinIter = table.getJoins().iterator();
		while (joinIter.hasNext()) {
			WmJoin join = (WmJoin) joinIter.next();
			join.accept(this);
		}
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.visitor.VisitorWrapper#visit(org.asyrinx.brownie.windmill.model.WmTableAspect)
	 */
	public void visit(WmTableAspect tableAspect) {
		super.visit(tableAspect);
		visitTableImpl(tableAspect);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmUnique)
	 */
	public void visit(WmUnique unique) {
		super.visit(unique);
	}

}
