/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/29
 */
package org.asyrinx.joey.gen.model.visitor;

import org.asyrinx.joey.gen.model.IVisitor;
import org.asyrinx.joey.gen.model.WmAppData;
import org.asyrinx.joey.gen.model.WmAspect;
import org.asyrinx.joey.gen.model.WmAspectAction;
import org.asyrinx.joey.gen.model.WmAspectRef;
import org.asyrinx.joey.gen.model.WmColumn;
import org.asyrinx.joey.gen.model.WmColumnFormat;
import org.asyrinx.joey.gen.model.WmDatabase;
import org.asyrinx.joey.gen.model.WmEnum;
import org.asyrinx.joey.gen.model.WmEnumEntry;
import org.asyrinx.joey.gen.model.WmForeignKey;
import org.asyrinx.joey.gen.model.WmIdMethodParameter;
import org.asyrinx.joey.gen.model.WmIndex;
import org.asyrinx.joey.gen.model.WmInheritance;
import org.asyrinx.joey.gen.model.WmJoin;
import org.asyrinx.joey.gen.model.WmProperty;
import org.asyrinx.joey.gen.model.WmTable;
import org.asyrinx.joey.gen.model.WmTableAspect;
import org.asyrinx.joey.gen.model.WmUnique;

/**
 * @author akima
 */
public class VisitorWrapper implements IVisitor {

	/**
	 * 
	 */
	public VisitorWrapper(IVisitor wrapped) {
		super();
		this.wrapped = wrapped;
	}

	protected IVisitor wrapped;

	/**
	 * @param appData
	 */
	public void visit(WmAppData appData) {
		wrapped.visit(appData);
	}

	/**
	 * @param aspect
	 */
	public void visit(WmAspect aspect) {
		wrapped.visit(aspect);
	}

	/**
	 * @param aspectAction
	 */
	public void visit(WmAspectAction aspectAction) {
		wrapped.visit(aspectAction);
	}

	/**
	 * @param aspectRef
	 */
	public void visit(WmAspectRef aspectRef) {
		wrapped.visit(aspectRef);
	}

	/**
	 * @param column
	 */
	public void visit(WmColumn column) {
		wrapped.visit(column);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmColumnFormat)
	 */
	public void visit(WmColumnFormat format) {
		wrapped.visit(format);
	}

	/**
	 * @param database
	 */
	public void visit(WmDatabase database) {
		wrapped.visit(database);
	}

	/**
	 * @param enum
	 */
	public void visit(WmEnum enum) {
		wrapped.visit(enum);
	}

	/**
	 * @param enumEntry
	 */
	public void visit(WmEnumEntry enumEntry) {
		wrapped.visit(enumEntry);
	}

	/**
	 * @param foreignKey
	 */
	public void visit(WmForeignKey foreignKey) {
		wrapped.visit(foreignKey);
	}

	/**
	 * @param idMethodParameter
	 */
	public void visit(WmIdMethodParameter idMethodParameter) {
		wrapped.visit(idMethodParameter);
	}

	/**
	 * @param index
	 */
	public void visit(WmIndex index) {
		wrapped.visit(index);
	}

	/**
	 * @param inheritance
	 */
	public void visit(WmInheritance inheritance) {
		wrapped.visit(inheritance);
	}

	/**
	 * @param join
	 */
	public void visit(WmJoin join) {
		wrapped.visit(join);
	}

	/**
	 * @param property
	 */
	public void visit(WmProperty property) {
		wrapped.visit(property);
	}

	/**
	 * @param table
	 */
	public void visit(WmTable table) {
		wrapped.visit(table);
	}

	/**
	 * @see org.asyrinx.brownie.windmill.model.IVisitor#visit(org.asyrinx.brownie.windmill.model.WmTableAspect)
	 */
	public void visit(WmTableAspect tableAspect) {
		wrapped.visit(tableAspect);
	}

	/**
	 * @param unique
	 */
	public void visit(WmUnique unique) {
		wrapped.visit(unique);
	}

}
