/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/29
 */
package org.asyrinx.joey.gen.model.xml;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.StringUtils;
import org.asyrinx.brownie.core.xml.digester.SettingDigester;
import org.asyrinx.joey.gen.model.IElement;
import org.asyrinx.joey.gen.model.IVisitor;
import org.asyrinx.joey.gen.model.WmAppData;
import org.asyrinx.joey.gen.model.WmAspect;
import org.asyrinx.joey.gen.model.WmAspectActionSet;
import org.asyrinx.joey.gen.model.WmAspectRef;
import org.asyrinx.joey.gen.model.WmColumn;
import org.asyrinx.joey.gen.model.WmColumnFormat;
import org.asyrinx.joey.gen.model.WmDatabase;
import org.asyrinx.joey.gen.model.WmEnum;
import org.asyrinx.joey.gen.model.WmEnumEntry;
import org.asyrinx.joey.gen.model.WmForeignKey;
import org.asyrinx.joey.gen.model.WmIdMethodParameter;
import org.asyrinx.joey.gen.model.WmIndex;
import org.asyrinx.joey.gen.model.WmInheritance;
import org.asyrinx.joey.gen.model.WmJoin;
import org.asyrinx.joey.gen.model.WmProperty;
import org.asyrinx.joey.gen.model.WmTable;
import org.asyrinx.joey.gen.model.WmTableAspect;
import org.asyrinx.joey.gen.model.WmUnique;
import org.asyrinx.joey.gen.model.visitor.CommonVisitor;
import org.asyrinx.joey.gen.model.visitor.TopDownVisitor;
import org.xml.sax.SAXException;

/**
 * @author akima
 */
public class AppDataBuilder {

	public AppDataBuilder(
		String databaseType,
		String defaultPackage,
		String basePropsFilePath) {
		appData = new WmAppData(databaseType, basePropsFilePath);
		this.defaultPackage = defaultPackage;
	}

	private final String defaultPackage;

	private final WmAppData appData;

	public WmAppData execute(String fileName)
		throws IOException, SAXException {
		final InputStream inputStream =
			new BufferedInputStream(new FileInputStream(fileName));
		return execute(inputStream);
	}

	public WmAppData execute(InputStream sourceStream)
		throws IOException, SAXException {
		final WmAppData result = executeDigester(sourceStream);
		if (result == null)
			return null;
		preparePackage(result.getDbIterator());
		finishLoad(result);
		applyTableAspects(result.getDbIterator());
		return result;
	}

	private WmAppData executeDigester(InputStream sourceStream)
		throws IOException, SAXException {
		final SettingDigester d = new SettingDigester();
		d.setValidating(false);

		d.addRoot("database", WmDatabase.class);
		d.addSetProperties("database");
		d.addProps("database/aspect", WmAspect.class, "addAspect");
		d.addProps(
			"database/aspect/set-value",
			WmAspectActionSet.class,
			"addAction");

		//WmTableAspect
		d.addProps(
			"database/tableAspect",
			WmTableAspect.class,
			"addTableAspect");
		d.addCallMethod(
			"database/tableAspect/include",
			"addInclude",
			new Class[] { String.class },
			new String[] { "pattern" });
		d.addCallMethod(
			"database/tableAspect/exclude",
			"addExclude",
			new Class[] { String.class },
			new String[] { "pattern" });

		d.addProps("database/enum", WmEnum.class, "addEnum");
		d.addProps("database/enum/enum-entry", WmEnumEntry.class, "addEntry");

		//WmTable
		d.addProps("database/table", WmTable.class, "addTable");

		d.addProps(
			"*/column/id-method-parameter",
			WmIdMethodParameter.class,
			"addIdMethodParameter");

		d.addProps("*/column", WmColumn.class, "addColumn");
		d.addProps(
			"*/column/inheritance",
			WmInheritance.class,
			"addInheritance");
		d.addProps("*/column/property", WmProperty.class, "addProperty");
		d.addProps("*/property/format", WmColumnFormat.class, "setFormat");
		d.addProps("*/column/format", WmColumnFormat.class, "setFormat");

		d.addProps("*/foreign-key", WmForeignKey.class, "addForeignKey");
		d.addCallMethod(
			"*/foreign-key/reference",
			"addReference",
			new Class[] { String.class, String.class },
			new String[] { "local", "foreign" });

		d.addProps("*/index", WmIndex.class, "addIndex");
		d.addCallMethod(
			"*/index/index-column",
			"addColumn",
			new Class[] { String.class },
			new String[] { "name" });

		d.addProps("*/unique", WmUnique.class, "addUnique");
		d.addCallMethod(
			"*/unique/unique-column",
			"addColumn",
			new Class[] { String.class },
			new String[] { "name" });

		d.addProps("*/aspect-ref", WmAspectRef.class, "addAspectRef");
		d.addProps("*/view-join", WmJoin.class, "addJoin");

		final Object result = d.parse(sourceStream);
		if (result instanceof WmDatabase) {
			appData.addDatabase((WmDatabase) result);
			return appData;
		} else {
			return null;
		}
	}

	protected void preparePackage(final Iterator dbIter) {
		while (dbIter.hasNext()) {
			final WmDatabase db = (WmDatabase) dbIter.next();
			final Iterator tableIter =
				IteratorUtils.arrayIterator(db.getTables());
			while (tableIter.hasNext()) {
				final WmTable table = (WmTable) tableIter.next();
				if (StringUtils.isEmpty(table.getPackage()))
					table.setPackage(this.defaultPackage);
			}
		}
	}

	protected void applyTableAspects(final Iterator dbIter) {
		while (dbIter.hasNext()) {
			final WmDatabase db = (WmDatabase) dbIter.next();
			final Iterator tableAspectIter = db.getTableAspects().iterator();
			while (tableAspectIter.hasNext()) {
				final WmTableAspect tableAspect =
					(WmTableAspect) tableAspectIter.next();
				tableAspect.apply();
			}
		}
	}

	protected void finishLoad(final WmAppData appData) {
		final IVisitor visitor = new TopDownVisitor(new CommonVisitor() {
			/**
			 * @see org.asyrinx.brownie.windmill.model.visitor.CommonVisitor#visitCommon(java.lang.Object)
			 */
			protected void visitCommon(Object object) {
				if (object instanceof IElement) {
					((IElement) object).finishLoad();
				}
			}
		});
		appData.accept(visitor);
	}

}
