/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/18
 */
package org.asyrinx.joey.gen.options;

/**
 * @author akima
 */
public abstract class OmType {

	/**
	 * 
	 */
	public OmType() {
		super();
	}

	abstract public String getPeerException();
	abstract public String getPeerExceptionShortName();

	public static OmType findOmType(Object omTypeName) {
		if ("torque".equalsIgnoreCase(String.valueOf(omTypeName) )) {
			return TORQUE;
		} else {
			return POJO;
		}
	}

	public static final OmType TORQUE = new OmType() {
		public String getPeerException() {
			return "org.apache.torque.TorqueException";
		}
		public String getPeerExceptionShortName() {
			return "TorqueException";
		}
	};

	public static final OmType POJO = new OmType() {
		public String getPeerException() {
			return "org.springframework.dao.DataAccessException";
		}
		public String getPeerExceptionShortName() {
			return "DataAccessException";
		}
	};

}
