/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/02/08
 */
package org.asyrinx.joey.gen.task;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.NoSuchElementException;

import org.apache.tools.ant.Project;
import org.apache.velocity.context.Context;

import com.workingdogs.village.QueryDataSet;
import com.workingdogs.village.Record;

/**
 * @author akima
 */
public class JoeyDataDumpTask extends JoeyDataModelTask {

	/**
	 * Database name.
	 */
	private String databaseName;

	/**
	 * Database URL used for JDBC connection.
	 */
	private String databaseUrl;

	/**
	 * Database driver used for JDBC connection.
	 */
	private String databaseDriver;

	/**
	 * Database user used for JDBC connection.
	 */
	private String databaseUser;

	/**
	 * Database password used for JDBC connection.
	 */
	private String databasePassword;

	/**
	 * The database connection used to retrieve the data to dump.
	 */
	private Connection conn;

	/**
	 * The statement used to acquire the data to dump.
	 */
	private Statement stmt;

	/**
	 * Get the database name to dump
	 *
	 * @return  The DatabaseName value
	 */
	public String getDatabaseName() {
		return databaseName;
	}

	/**
	 * Set the database name
	 *
	 * @param  v The new DatabaseName value
	 */
	public void setDatabaseName(String v) {
		databaseName = v;
	}

	/**
	 * Get the database url
	 *
	 * @return  The DatabaseUrl value
	 */
	public String getDatabaseUrl() {
		return databaseUrl;
	}

	/**
	 * Set the database url
	 *
	 * @param  v The new DatabaseUrl value
	 */
	public void setDatabaseUrl(String v) {
		databaseUrl = v;
	}

	/**
	 * Get the database driver name
	 *
	 * @return  String database driver name
	 */
	public String getDatabaseDriver() {
		return databaseDriver;
	}

	/**
	 * Set the database driver name
	 *
	 * @param  v The new DatabaseDriver value
	 */
	public void setDatabaseDriver(String v) {
		databaseDriver = v;
	}

	/**
	 * Get the database user
	 *
	 * @return  String database user
	 */
	public String getDatabaseUser() {
		return databaseUser;
	}

	/**
	 * Set the database user
	 *
	 * @param  v The new DatabaseUser value
	 */
	public void setDatabaseUser(String v) {
		databaseUser = v;
	}

	/**
	 * Get the database password
	 *
	 * @return  String database password
	 */
	public String getDatabasePassword() {
		return databasePassword;
	}

	/**
	 * Set the database password
	 *
	 * @param  v The new DatabasePassword value
	 */
	public void setDatabasePassword(String v) {
		databasePassword = v;
	}

	/**
	 * Initializes initial context
	 *
	 * @return the context
	 * @throws Exception generic exception
	 */
	public Context initControlContext() throws Exception {
		super.initControlContext();

		context.put("dataset", "all");

		log("Torque - TorqueDataDump starting");
		log("Your DB settings are:");
		log("driver: " + databaseDriver);
		log("URL: " + databaseUrl);
		log("user: " + databaseUser);
		// log("password: " + databasePassword);

		try {
			Class.forName(databaseDriver);
			log("DB driver instantiated sucessfully", Project.MSG_DEBUG);

			conn =
				DriverManager.getConnection(
					databaseUrl,
					databaseUser,
					databasePassword);

			log("DB connection established", Project.MSG_DEBUG);
			context.put("tableTool", new TableTool());
		} catch (SQLException se) {
			System.err.println("SQLException while connecting to DB:");
			se.printStackTrace();
		} catch (ClassNotFoundException cnfe) {
			System.err.println("cannot load driver:");
			cnfe.printStackTrace();
		}
		context.put("escape", new org.apache.velocity.anakia.Escape());
		return context;
	}

	/**
	 * Closes the db-connection, overriding the <code>cleanup()</code> hook
	 * method in <code>TexenTask</code>.
	 *
	 * @throws Exception Database problem while closing resource.
	 */
	protected void cleanup() throws Exception {
		if (stmt != null) {
			stmt.close();
		}

		if (conn != null) {
			conn.close();
		}
	}

	/**
	 *  A nasty do-it-all tool class. It serves as:
	 *  <ul>
	 *  <li>context tool to fetch a table iterator</li>
	 *  <li>the abovenamed iterator which iterates over the table</li>
	 *  <li>getter for the table fields</li>
	 *  </ul>
	 *
	 * @author  fedor
	 */
	public class TableTool implements Iterator {
		/** querydataset */
		private QueryDataSet qds;
		/** is empty */
		private boolean isEmpty;
		/** current index */
		private int curIndex = -1;
		/** current record */
		private Record curRec = null;

		/**
		 *  Constructor for the TableTool object
		 */
		public TableTool() {
		}

		/**
		 * Constructor for the TableTool object
		 *
		 * @param qds Description of Parameter
		 * @throws Exception Problem using database record set cursor.
		 */
		protected TableTool(QueryDataSet qds) throws Exception {
			this.qds = qds;
			this.qds.fetchRecords();
			this.isEmpty = !(qds.size() > 0);
		}

		/**
		 * Fetches an <code>Iterator</code> for the data in the named table.
		 *
		 * @param  tableName Description of Parameter
		 * @return <code>Iterator</code> for the fetched data.
		 * @throws Exception Problem creating connection or executing query.
		 */
		public TableTool fetch(String tableName) throws Exception {
			log("Fetching data for table " + tableName, Project.MSG_INFO);
			// Set Statement object in associated TorqueDataDump
			// instance
			return new TableTool(
				new QueryDataSet(conn, "SELECT * FROM " + tableName));
		}

		/**
		 * check if there are more records in the QueryDataSet
		 *
		 * @return true if there are more records
		 */
		public boolean hasNext() {
			try {
				return ((this.curIndex < this.qds.size() - 1) && (!isEmpty));
			} catch (Exception se) {
				System.err.println("Exception :");
				se.printStackTrace();
			}
			return false;
		}

		/**
		 * load the next record from the QueryDataSet
		 *
		 * @return Description of the Returned Value
		 * @throws NoSuchElementException Description of Exception
		 */
		public Object next() throws NoSuchElementException {
			try {
				System.err.print(".");
				this.curRec = this.qds.getRecord(++curIndex);
			} catch (Exception se) {
				System.err.println("Exception while iterating:");
				se.printStackTrace();
				throw new NoSuchElementException(se.getMessage());
			}
			return this;
		}

		/**
		 * Returns the value for the column
		 *
		 * @param  columnName name of the column
		 * @return  value of the column or null if it doesn't exist
		 */
		public String get(String columnName) {
			try {
				return (this.curRec.getValue(columnName).asString());
			} catch (Exception se) {
				log(
					"Exception fetching value "
						+ columnName
						+ ": "
						+ se.getMessage(),
					Project.MSG_ERR);
			}
			return null;
		}

		/**
		 * unsupported! always throws Exception
		 *
		 * @throws UnsupportedOperationException unsupported
		 */
		public void remove() throws UnsupportedOperationException {
			throw new UnsupportedOperationException();
		}
	}
}
