/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2003/12/30
 */
package org.asyrinx.joey.gen.task;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.exception.NestableRuntimeException;
import org.apache.torque.engine.EngineException;
import org.apache.torque.engine.database.model.Database;
import org.apache.torque.engine.database.model.JavaNameGenerator;
import org.apache.torque.engine.database.model.NameFactory;
import org.asyrinx.brownie.core.io.StreamUtils;
import org.asyrinx.brownie.core.io.sf.StreamFactory;
import org.asyrinx.brownie.core.io.sf.StreamFactoryFacade;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.joey.gen.model.WmAppData;
import org.asyrinx.joey.gen.model.WmJoin;
import org.asyrinx.joey.gen.model.WmTable;

/**
 * @author akima
 */
public class PageGeneratingHelper {

	/**
	 * 
	 */
	public PageGeneratingHelper() {
		super();
	}

	public String toJavaName(String value) {
		return toJavaNameUnderScore(value);
	}

	public String toJavaName(String value, String javaNamingMethod) {
		final List inputs = new ArrayList(2);
		inputs.add(value);
		inputs.add(javaNamingMethod);
		try {
			return NameFactory.generateName(NameFactory.JAVA_GENERATOR, inputs);
		} catch (EngineException e) {
			throw new NestableRuntimeException(e);
		}
	}

	public String toJavaNameUnderScore(String value) {
		return toJavaName(value, JavaNameGenerator.CONV_METHOD_UNDERSCORE);
	}

	public String toJavaNameJavaName(String value) {
		return toJavaName(value, JavaNameGenerator.CONV_METHOD_JAVANAME);
	}

	public String toJavaNameNoChange(String value) {
		return toJavaName(value, JavaNameGenerator.CONV_METHOD_NOCHANGE);
	}

	public boolean match(String value, String options) {
		final List optionList = StringUtils.tokenize(options, ",");
		return optionList.indexOf(value) > -1;
	}

	public List getAllTables(List appDataList) {
		final List result = new ArrayList();
		final Iterator appIter = appDataList.iterator();
		while (appIter.hasNext()) {
			final WmAppData appData = (WmAppData) appIter.next();
			final Iterator dbIter = appData.getDbIterator();
			while (dbIter.hasNext()) {
				final Database db = (Database) dbIter.next();
				final Iterator tableIter =
					IteratorUtils.arrayIterator(db.getTables());
				while (tableIter.hasNext()) {
					result.add(tableIter.next());
				}
			}
		}
		return result;
	}

	public WmTable findUserTable(List tableList) {
		final Iterator iterator = tableList.iterator();
		while (iterator.hasNext()) {
			WmTable table = (WmTable) iterator.next();
			if (table.isLoginUser())
				return table;
		}
		return null;
	}

	public boolean containJoin(List joins, String type) {
		final Iterator iterator = joins.iterator();
		while (iterator.hasNext()) {
			final WmJoin join = (WmJoin) iterator.next();
			if (StringUtils.equals(join.getType(), type))
				return true;
		}
		return false;
	}

	public boolean containOneToOneJoin(List joins) {
		return containJoin(joins, "oneToOne");
	}

	public boolean containOneToManyJoin(List joins) {
		return containJoin(joins, "oneToMany");
	}

	private Map stackMap = new HashMap();

	public Stack getStack(String name) {
		Stack result = (Stack) stackMap.get(name);
		if (result == null) {
			result = new Stack();
			stackMap.put(name, result);
		}
		return result;
	}

	public void clearStack(String stackName) {
		final Stack stack = getStack(stackName);
		stack.clear();
	}

	public void push(String stackName, Object value) {
		final Stack stack = getStack(stackName);
		stack.push(value);
	}

	public Object pop(String stackName) {
		final Stack stack = getStack(stackName);
		return stack.pop();
	}

	public Object newInstance(String className) {
		try {
			return Class.forName(className).newInstance();
		} catch (Exception e) {
			return null;
		}
	}

	public void copyFile(String sourceFilename, String destFilename)
		throws IOException {
		final File source = new File(sourceFilename);
		if (!source.exists())
			throw new FileNotFoundException(sourceFilename);
		final FileInputStream inputStream = new FileInputStream(source);
		final FileOutputStream outputStream =
			new FileOutputStream(destFilename);
		StreamUtils.copy(inputStream, outputStream);
		inputStream.close();
		outputStream.close();
	}

	public void copyResourceToFile(
		String sourceResourcePath,
		String destFilename)
		throws IOException {

		final StreamFactory sf = StreamFactoryFacade.newFacade();
		final InputStream inputStream = sf.newInput(sourceResourcePath);
		final FileOutputStream outputStream =
			new FileOutputStream(destFilename);
		byte buf[] = new byte[256];
		int len;
		while ((len = inputStream.read(buf)) != -1) {
			outputStream.write(buf, 0, len);
		}
		outputStream.flush();
		outputStream.close();
		inputStream.close();
	}

}
