/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/29
 */
package test.org.asyrinx.brownie.windmill.model.xml;

import java.io.InputStream;

import junit.framework.TestCase;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.TypeMap;
import org.asyrinx.brownie.core.io.sf.FileStreamFactory;
import org.asyrinx.brownie.core.io.sf.RelativeClassResourceStreamFactory;
import org.asyrinx.joey.gen.model.WmAppData;
import org.asyrinx.joey.gen.model.WmAspect;
import org.asyrinx.joey.gen.model.WmAspectRef;
import org.asyrinx.joey.gen.model.WmColumn;
import org.asyrinx.joey.gen.model.WmDatabase;
import org.asyrinx.joey.gen.model.WmEnum;
import org.asyrinx.joey.gen.model.WmEnumEntry;
import org.asyrinx.joey.gen.model.WmForeignKey;
import org.asyrinx.joey.gen.model.WmIndex;
import org.asyrinx.joey.gen.model.WmJoin;
import org.asyrinx.joey.gen.model.WmProperty;
import org.asyrinx.joey.gen.model.WmTable;
import org.asyrinx.joey.gen.model.WmUnique;
import org.asyrinx.joey.gen.model.xml.AppDataBuilder;

/**
 * @author akima
 */
public class AppDataBuilderTest extends TestCase {

	/**
	 * Constructor for AppDataBuilderTest.
	 * @param name
	 */
	public AppDataBuilderTest(String name) {
		super(name);
	}

	public static void main(String[] args) {
		junit.swingui.TestRunner.run(AppDataBuilderTest.class);
	}

	Log log = LogFactory.getLog(this.getClass());

	/*
	 * Test for WmAppData execute(InputStream)
	 */
	public void testExecuteInputStream() {
		//BasicConfigurator.configure();

		TypeMap.initialize();

		final FileStreamFactory streamFactory =
			new RelativeClassResourceStreamFactory();
		try {
			final InputStream inputStream =
				streamFactory.newInput("chiffon-schema.xml");

			AppDataBuilder builder =
				new AppDataBuilder("postgresql", "test", "sql/base/");
			WmAppData appData = builder.execute(inputStream);
			//describe(appData);

			//<database name="chiffon" defaultIdMethod="idbroker">
			assertEquals(null, appData.getName());
			assertEquals(1, appData.getDatabases().length);
			final WmDatabase db = (WmDatabase) appData.getDatabase();
			assertEquals("chiffon", db.getName());
			assertEquals("idbroker", db.getDefaultIdMethod());

			//<aspect name="must_have_update_member_id" where="page.before.save" >
			//	<set-value columnName="update_member_id" type="bean" value="visit.loginUser.memberId" />
			//</aspect>
			//<aspect name="must_have_updated" where="peer.before.save" >
			//	<set-value columnName="updated" type="static" value="PeerUtils.getServerDate()" />
			//</aspect>

			assertEquals(2, db.getAspects().size());
			final WmAspect aspect0 = (WmAspect) db.getAspects().get(0);
			assertEquals("must_have_update_member_id", aspect0.getName());
			assertEquals("page.before.save", aspect0.getWhere());
			assertEquals(db, aspect0.getDatabase());
			final WmAspect aspect1 = (WmAspect) db.getAspects().get(1);
			assertEquals("must_have_updated", aspect1.getName());
			assertEquals("peer.before.save", aspect1.getWhere());
			assertEquals(db, aspect1.getDatabase());

			//<table name="party" idMethod="idbroker" description="[delete.method=logical, delete.flag=deleted ] abstract person or group">
			WmTable table = (WmTable) db.getTable("party");
			assertEquals("party", table.getName());
			assertEquals("idbroker", table.getIdMethod());
			//	<column name="party_id" required="true"  type="INTEGER" primaryKey="true" description="party id"/>
			WmColumn col = (WmColumn) table.getColumn("party_id");
			assertEquals("party_id", col.getName());
			assertEquals(true, col.isNotNull());
			assertEquals(true, col.isRequired());
			assertEquals("INTEGER", col.getTorqueType());
			assertEquals(true, col.isPrimaryKey());
			assertEquals(null, col.getJavaType());
			assertEquals(true, col.isUsePrimitive());
			//	<column name="name"     required="true"  type="VARCHAR" size="50" description="name"/>
			col = (WmColumn) table.getColumn("name");
			assertEquals("name", col.getName());
			assertEquals(true, col.isNotNull());
			assertEquals(true, col.isRequired());
			assertEquals("VARCHAR", col.getTorqueType());
			assertEquals(false, col.isPrimaryKey());
			assertEquals("50", col.getSize());
			//	<column name="updated"          required="true"  type="DATE"     description="when the record was updated"/>
			col = (WmColumn) table.getColumn("updated");
			assertEquals("updated", col.getName());
			assertEquals(true, col.isNotNull());
			assertEquals(true, col.isRequired());
			assertEquals("DATE", col.getTorqueType());
			assertEquals(false, col.isPrimaryKey());
			//	<column name="update_member_id" required="true"  type="INTEGER"  description="who updated the record"/>
			col = (WmColumn) table.getColumn("update_member_id");
			assertEquals("update_member_id", col.getName());
			assertEquals(true, col.isNotNull());
			assertEquals(true, col.isRequired());
			assertEquals("INTEGER", col.getTorqueType());
			assertEquals(false, col.isPrimaryKey());
			//	<index name="idx_party_name">
			//		<index-column name="name"/>
			//	</index>
			WmIndex index = (WmIndex) table.getIndices()[0];
			assertEquals("idx_party_name", index.getName());
			assertEquals(1, index.getColumns().size());
			assertEquals("name", index.getColumns().get(0));

			//	<aspect-ref name="must_have_update_member_id"/>
			//	<aspect-ref name="must_have_updated"/>
			assertEquals(2, table.getAspectRefs().size());
			assertEquals(
				"must_have_update_member_id",
				((WmAspectRef) table.getAspectRefs().get(0)).getName());
			assertEquals(
				"must_have_updated",
				((WmAspectRef) table.getAspectRefs().get(1)).getName());

			//	<join table="contact" type="oneToMany" foreignKey="fk_contact_party" />
			//</table>
			assertEquals(1, table.getJoins().size());
			WmJoin join = (WmJoin) table.getJoins().get(0);
			assertEquals(0, join.getChildren().size());
			assertEquals("contact", join.getTable());
			assertEquals("oneToMany", join.getType());
			assertEquals("fk_contact_party", join.getForeignKey());

			//<table name="member" idMethod="idbroker" isLoginUser="true" description="dev team member">
			table = (WmTable) db.getTable("member");
			assertEquals("member", table.getName());
			assertEquals("idbroker", table.getIdMethod());
			assertEquals(true, table.isLoginUser());
			//	<column name="member_id"      required="true"  type="INTEGER" primaryKey="true" description="member id"/>
			col = (WmColumn) table.getColumn("member_id");
			assertEquals("member_id", col.getName());
			assertEquals(true, col.isNotNull());
			assertEquals(true, col.isRequired());
			assertEquals("INTEGER", col.getTorqueType());
			assertEquals(true, col.isPrimaryKey());
			//	<enum name="MemberType" type="MemberType" valueType="int" label="member type" >
			//		<enum-entry name="viewer" value="1" />
			//		<enum-entry name="editor" value="2" />
			//		<enum-entry name="admin" value="3" />
			//	</enum>
			assertEquals(1, db.getEnums().size());
			WmEnum enum = (WmEnum) db.getEnums().get(0);
			assertEquals("MemberType", enum.getName());
			assertEquals("int", enum.getValueType());
			assertEquals("member type", enum.getLabel());
			assertEquals(3, enum.getEntries().size());
			assertEquals(
				"viewer",
				((WmEnumEntry) enum.getEntries().get(0)).getName());
			assertEquals(
				"1",
				((WmEnumEntry) enum.getEntries().get(0)).getValue());
			assertEquals(
				"editor",
				((WmEnumEntry) enum.getEntries().get(1)).getName());
			assertEquals(
				"2",
				((WmEnumEntry) enum.getEntries().get(1)).getValue());
			assertEquals(
				"admin",
				((WmEnumEntry) enum.getEntries().get(2)).getName());
			assertEquals(
				"3",
				((WmEnumEntry) enum.getEntries().get(2)).getValue());
			//	<column name="member_type_id" required="true"  type="INTEGER" description="type of member">
			//		<property name="memberType" type="MemberType" label="member type" />
			//	</column> 	
			col = (WmColumn) table.getColumn("member_type_id");
			assertEquals("member_type_id", col.getName());
			assertEquals(true, col.isNotNull());
			assertEquals(true, col.isRequired());
			assertEquals("INTEGER", col.getTorqueType());
			assertEquals(false, col.isPrimaryKey());
			assertNotNull(col.getAdditional());
			WmProperty property = col.getAdditional();
			assertEquals("memberType", property.getName());
			assertEquals("MemberType", property.getType());
			assertEquals("member type", property.getLabel());
			assertEquals(col, property.getColumn());

			//	<column name="party_id"       required="true"  type="INTEGER" description="party id" >
			//		<property name="partyName" type="String" label="party name" valueToGet="party.name" foreignProperty="name" readonly="true" />
			//	</column>
			col = (WmColumn) table.getColumn("party_id");
			assertEquals("party_id", col.getName());
			assertEquals(true, col.isNotNull());
			assertEquals(true, col.isRequired());
			assertEquals("INTEGER", col.getTorqueType());
			assertEquals(false, col.isPrimaryKey());
			assertNotNull(col.getAdditional());
			property = col.getAdditional();
			assertEquals("partyName", property.getName());
			assertEquals("String", property.getType());
			assertEquals("party name", property.getLabel());
			assertEquals("party.name", property.getValueToGet());
			assertEquals("name", property.getForeignProperty());
			assertEquals(col, property.getColumn());

			//	<column name="password"       required="false" type="VARCHAR" size="20" isLoginPassword="true" description="Password"/>
			col = (WmColumn) table.getColumn("password");
			assertEquals("password", col.getName());
			assertEquals(false, col.isNotNull());
			assertEquals(false, col.isRequired());
			assertEquals("VARCHAR", col.getTorqueType());
			assertEquals("20", col.getSize());
			assertEquals(false, col.isPrimaryKey());

			//	<foreign-key foreignTable="party">
			//		<reference local="party_id" foreign="party_id"/>
			//	</foreign-key>
			assertEquals(1, table.getForeignKeys().length);
			WmForeignKey foreignKey = (WmForeignKey) table.getForeignKeys()[0];
			assertEquals("party", foreignKey.getForeignTable());
			assertEquals(1, foreignKey.getLocalColumns().size());
			assertEquals(1, foreignKey.getForeignColumns().size());
			assertEquals("party_id", foreignKey.getLocalColumns().get(0));
			assertEquals("party_id", foreignKey.getForeignColumns().get(0));

			//	<unique name="unique_member_login_name">
			//		<unique-column name="login_name"/>
			//	</unique>
			assertEquals(1, table.getUnices().length);
			WmUnique unique = (WmUnique) table.getUnices()[0];
			assertEquals("unique_member_login_name", unique.getName());
			assertEquals(1, unique.getColumns().size());
			assertEquals("login_name", unique.getColumns().get(0));

			//	<index name="idx_member_party">
			//		<index-column name="party_id"/>
			//	</index>
			assertEquals(1, table.getIndices().length);
			index = (WmIndex) table.getIndices()[0];
			assertEquals("idx_member_party", index.getName());
			assertEquals(1, index.getColumns().size());
			assertEquals("party_id", index.getColumns().get(0));

			//	<join table="party" type="oneToOne" foreignKey="fk_member_party" >
			//		<join table="contact" type="oneToMany" foreignKey="fk_contact_party" />
			//	</join>
			assertEquals(1, table.getJoins().size());
			join = (WmJoin) table.getJoins().get(0);
			assertEquals(1, join.getChildren().size());
			assertEquals("party", join.getTable());
			assertEquals("oneToOne", join.getType());
			assertEquals("fk_member_party", join.getForeignKey());
			join = (WmJoin) join.getChildren().get(0);
			assertEquals(0, join.getChildren().size());
			assertEquals("contact", join.getTable());
			assertEquals("oneToMany", join.getType());
			assertEquals("fk_contact_party", join.getForeignKey());

			//</table>

		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}

	}

}
