/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2004/01/29
 */
package test.org.asyrinx.brownie.windmill.model.xml;

import java.io.InputStream;
import java.util.Iterator;

import junit.framework.TestCase;

import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.database.model.TypeMap;
import org.asyrinx.brownie.core.io.sf.FileStreamFactory;
import org.asyrinx.brownie.core.io.sf.RelativeClassResourceStreamFactory;
import org.asyrinx.joey.gen.model.WmAppData;
import org.asyrinx.joey.gen.model.WmDatabase;
import org.asyrinx.joey.gen.model.WmForeignKey;
import org.asyrinx.joey.gen.model.WmJoin;
import org.asyrinx.joey.gen.model.WmTable;
import org.asyrinx.joey.gen.model.WmTableAspect;
import org.asyrinx.joey.gen.model.xml.AppDataBuilder;

/**
 * @author akima
 */
public class AppDataBuilderTest2 extends TestCase {

	/**
	 * Constructor for AppDataBuilderTest.
	 * @param name
	 */
	public AppDataBuilderTest2(String name) {
		super(name);
	}

	public static void main(String[] args) {
		junit.swingui.TestRunner.run(AppDataBuilderTest2.class);
	}

	Log log = LogFactory.getLog(this.getClass());

	/*
	 * Test for WmAppData execute(InputStream)
	 */
	public void testExecuteInputStream() {
		//BasicConfigurator.configure();

		TypeMap.initialize();

		final FileStreamFactory streamFactory =
			new RelativeClassResourceStreamFactory();
		try {
			final InputStream inputStream =
				streamFactory.newInput("chiffon-schema_2.xml");

			AppDataBuilder builder =
				new AppDataBuilder("postgresql", "test", "sql/base/");
			WmAppData appData = builder.execute(inputStream);
			WmDatabase db = (WmDatabase) appData.getDatabase();

			WmTableAspect tableAspect =
				(WmTableAspect) db.getTableAspects().get(0);

			final WmTable project = (WmTable) db.getTable("project");
			assertEquals(1, db.getTableAspects().size());

			assertTrue(
				project.getColumn("updated")
					!= tableAspect.getColumn("updated"));
			assertTrue(
				project.getColumn("update_member_id")
					!= tableAspect.getColumn("update_member_id"));
			assertTrue(findFk(project) != findFk(tableAspect));
			//
			/*
					<join table="project_member_assign" type="oneToMany" foreignKey="fk_project_member_assign_project" >
						<join table="member" type="oneToOne" foreignKey="fk_project_member_assign_project_member" >
							<join table="party" type="oneToOne" foreignKey="fk_member_party" >
								<join table="contact" type="oneToMany" foreignKey="fk_contact_party" />
							</join>
						</join>
					</join>
			 */
			final WmJoin assign = (WmJoin) project.getJoins().get(1);
			final WmJoin member = (WmJoin) assign.getChildren().get(0);
			final WmJoin party = (WmJoin) member.getChildren().get(0);
			final WmJoin contact = (WmJoin) party.getChildren().get(0);
			assertEquals("", assign.getChainedBeanNameFromMany());
			assertEquals("member", member.getChainedBeanNameFromMany());
			assertEquals("member.party", party.getChainedBeanNameFromMany());
			assertEquals("", contact.getChainedBeanNameFromMany());

		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}

	}

	private WmForeignKey findFk(WmTable project) {
		WmForeignKey project_fk_update_member = null;
		final Iterator iterator =
			IteratorUtils.arrayIterator(project.getForeignKeys());
		while (iterator.hasNext()) {
			WmForeignKey fk = (WmForeignKey) iterator.next();
			if ("member".equals(fk.getForeignTable()))
				project_fk_update_member = fk;
		}
		return project_fk_update_member;
	}

}
