/*
 * Joey and its relative products are published under the terms
 * of the Apache Software License.
 */
/*
 * Created on 2003/12/30
 */
package test.org.asyrinx.brownie.windmill.task;

import junit.framework.TestCase;

import org.apache.commons.lang.StringUtils;
import org.asyrinx.joey.gen.task.PageGeneratingHelper;

/**
 * @author akima
 */
public class PageGeneratingHelperTest extends TestCase {

	/**
	 * Constructor for PageGeneratingHelperTest.
	 * @param name
	 */
	public PageGeneratingHelperTest(String name) {
		super(name);
	}

	public static void main(String[] args) {
		junit.swingui.TestRunner.run(PageGeneratingHelperTest.class);
	}

	public void testToJavaName() {
		final PageGeneratingHelper helper = new PageGeneratingHelper();
		assertEquals("abc", helper.toJavaNameNoChange("abc"));
		assertEquals("Abc", helper.toJavaNameJavaName("abc"));
		assertEquals("Abc", helper.toJavaNameUnderScore("abc"));

		assertEquals("ABC", helper.toJavaNameNoChange("ABC"));
		assertEquals("ABC", helper.toJavaNameJavaName("ABC"));
		assertEquals("Abc", helper.toJavaNameUnderScore("ABC"));

		assertEquals("abc_def", helper.toJavaNameNoChange("abc_def"));
		assertEquals("AbcDef", helper.toJavaNameJavaName("abc_def"));
		assertEquals("AbcDef", helper.toJavaNameUnderScore("abc_def"));

		assertEquals("ABC_DEF", helper.toJavaNameNoChange("ABC_DEF"));
		assertEquals("ABCDEF", helper.toJavaNameJavaName("ABC_DEF"));
		assertEquals("AbcDef", helper.toJavaNameUnderScore("ABC_DEF"));

		assertEquals("_abc_def", helper.toJavaNameNoChange("_abc_def"));
		assertEquals("AbcDef", helper.toJavaNameJavaName("_abc_def"));
		assertEquals("AbcDef", helper.toJavaNameUnderScore("abc_def"));

		assertEquals("_ABC_DEF", helper.toJavaNameNoChange("_ABC_DEF"));
		assertEquals("ABCDEF", helper.toJavaNameJavaName("_ABC_DEF"));
		assertEquals("AbcDef", helper.toJavaNameUnderScore("_ABC_DEF"));
	}

	public void testToUpperCaseHead() {
		assertEquals(null, StringUtils.uncapitalize(null));
		assertEquals("", StringUtils.capitalize(""));
		assertEquals("A", StringUtils.capitalize("a"));
		assertEquals("A", StringUtils.capitalize("A"));
		assertEquals("Abc", StringUtils.capitalize("abc"));
		assertEquals("ABC", StringUtils.capitalize("ABC"));
		assertEquals("_abc", StringUtils.capitalize("_abc"));
		assertEquals("_ABC", StringUtils.capitalize("_ABC"));
	}
	public void testToLowerCaseHead() {
		assertEquals(null, StringUtils.uncapitalize(null));
		assertEquals("", StringUtils.uncapitalize(""));
		assertEquals("a", StringUtils.uncapitalize("a"));
		assertEquals("a", StringUtils.uncapitalize("A"));
		assertEquals("abc", StringUtils.uncapitalize("abc"));
		assertEquals("aBC", StringUtils.uncapitalize("ABC"));
		assertEquals("_abc", StringUtils.uncapitalize("_abc"));
		assertEquals("_ABC", StringUtils.uncapitalize("_ABC"));
	}

}
