/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.engine.database.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.engine.EngineException;
import org.apache.torque.engine.database.model.ForeignKey;
import org.apache.torque.engine.database.model.Inheritance;
import org.apache.torque.engine.database.model.NameFactory;
import org.apache.torque.engine.database.model.Table;
import org.apache.torque.engine.database.model.TypeMap;
import org.xml.sax.Attributes;

public class Column {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$torque$engine$database$model$Column == null ? (class$org$apache$torque$engine$database$model$Column = Column.class$("org.apache.torque.engine.database.model.Column")) : class$org$apache$torque$engine$database$model$Column));
    private String name;
    private String description;
    private String javaName = null;
    private String javaNamingMethod;
    private boolean isNotNull = false;
    private String size;
    private String torqueType;
    private String javaType;
    private Object columnType;
    private Table parentTable;
    private int position;
    private boolean isPrimaryKey = false;
    private boolean isUnique = false;
    private boolean isAutoIncrement = false;
    private String defaultValue;
    private List referrers;
    private String inheritanceType;
    private boolean isInheritance;
    private boolean isEnumeratedClasses;
    private List inheritanceList;
    private boolean needsTransactionInPostgres;
    private String inputValidator = null;
    static /* synthetic */ Class class$org$apache$torque$engine$database$model$Column;

    public Column() {
        this(null);
    }

    public Column(String name) {
        this.name = name;
    }

    public static String makeList(List columns) {
        Object obj = columns.get(0);
        boolean isColumnList = obj instanceof Column;
        if (isColumnList) {
            obj = ((Column)obj).getName();
        }
        StringBuffer buf = new StringBuffer((String)obj);
        for (int i = 1; i < columns.size(); ++i) {
            obj = columns.get(i);
            if (isColumnList) {
                obj = ((Column)obj).getName();
            }
            buf.append(", ").append(obj);
        }
        return buf.toString();
    }

    public void loadFromXML(Attributes attrib) {
        String notNull;
        this.name = attrib.getValue("name");
        this.javaName = attrib.getValue("javaName");
        this.javaType = attrib.getValue("javaType");
        if (this.javaType != null && this.javaType.length() == 0) {
            this.javaType = null;
        }
        this.javaNamingMethod = attrib.getValue("javaNamingMethod");
        if (this.javaNamingMethod == null) {
            this.javaNamingMethod = this.parentTable.getDatabase().getDefaultJavaNamingMethod();
        }
        String primaryKey = attrib.getValue("primaryKey");
        this.isPrimaryKey = "true".equals(primaryKey);
        if ("true".equals(primaryKey)) {
            this.isNotNull = true;
        }
        this.isNotNull = (notNull = attrib.getValue("required")) != null && "true".equals(notNull);
        String autoIncrement = attrib.getValue("autoIncrement");
        this.isAutoIncrement = "true".equals(autoIncrement);
        this.defaultValue = attrib.getValue("default");
        this.size = attrib.getValue("size");
        this.setType(attrib.getValue("type"));
        this.inheritanceType = attrib.getValue("inheritance");
        this.isInheritance = this.inheritanceType != null && !this.inheritanceType.equals("false");
        this.inputValidator = attrib.getValue("inputValidator");
        this.description = attrib.getValue("description");
    }

    public String getFullyQualifiedName() {
        return this.parentTable.getName() + '.' + this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String newDescription) {
        this.description = newDescription;
    }

    public String getJavaName() {
        if (this.javaName == null) {
            ArrayList<String> inputs = new ArrayList<String>(2);
            inputs.add(this.name);
            inputs.add(this.javaNamingMethod);
            try {
                this.javaName = NameFactory.generateName(NameFactory.JAVA_GENERATOR, inputs);
            }
            catch (EngineException e) {
                log.error((Object)e, (Throwable)((Object)e));
            }
        }
        return StringUtils.capitalise((String)this.javaName);
    }

    public String getUncapitalisedJavaName() {
        return StringUtils.uncapitalise((String)this.getJavaName());
    }

    public void setJavaName(String javaName) {
        this.javaName = javaName;
    }

    public String getJavaType() {
        return this.javaType;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int v) {
        this.position = v;
    }

    public void setTable(Table parent) {
        this.parentTable = parent;
    }

    public Table getTable() {
        return this.parentTable;
    }

    public String getTableName() {
        return this.parentTable.getName();
    }

    public Inheritance addInheritance(Attributes attrib) {
        Inheritance inh = new Inheritance();
        inh.loadFromXML(attrib);
        this.addInheritance(inh);
        return inh;
    }

    public void addInheritance(Inheritance inh) {
        inh.setColumn(this);
        if (this.inheritanceList == null) {
            this.inheritanceList = new ArrayList();
            this.isEnumeratedClasses = true;
        }
        this.inheritanceList.add(inh);
    }

    public List getChildren() {
        return this.inheritanceList;
    }

    public boolean isInheritance() {
        return this.isInheritance;
    }

    public boolean isEnumeratedClasses() {
        return this.isEnumeratedClasses;
    }

    public boolean isNotNull() {
        return this.isNotNull;
    }

    public void setNotNull(boolean status) {
        this.isNotNull = status;
    }

    public void setPrimaryKey(boolean pk) {
        this.isPrimaryKey = pk;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public void setUnique(boolean u) {
        this.isUnique = u;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public boolean requiresTransactionInPostgres() {
        return this.needsTransactionInPostgres;
    }

    public boolean isForeignKey() {
        return this.getForeignKey() != null;
    }

    public boolean isMultipleFK() {
        ForeignKey fk = this.getForeignKey();
        if (fk != null) {
            ForeignKey[] fks = this.parentTable.getForeignKeys();
            for (int i = 0; i < fks.length; ++i) {
                if (!fks[i].getForeignTableName().equals(fk.getForeignTableName()) || fks[i].getLocalColumns().contains(this.name)) continue;
                return true;
            }
        }
        return false;
    }

    public ForeignKey getForeignKey() {
        return this.parentTable.getForeignKey(this.name);
    }

    public String getRelatedTableName() {
        ForeignKey fk = this.getForeignKey();
        return fk == null ? null : fk.getForeignTableName();
    }

    public String getRelatedColumnName() {
        ForeignKey fk = this.getForeignKey();
        if (fk == null) {
            return null;
        }
        return fk.getLocalForeignMapping().get(this.name).toString();
    }

    public void addReferrer(ForeignKey fk) {
        if (this.referrers == null) {
            this.referrers = new ArrayList(5);
        }
        this.referrers.add(fk);
    }

    public List getReferrers() {
        if (this.referrers == null) {
            this.referrers = new ArrayList(5);
        }
        return this.referrers;
    }

    public void setType(String torqueType) {
        this.torqueType = torqueType;
        if (torqueType.equals("VARBINARY") || torqueType.equals("BLOB")) {
            this.needsTransactionInPostgres = true;
        }
    }

    public Object getType() {
        return TypeMap.getJdbcType(this.torqueType);
    }

    public Object getTorqueType() {
        return this.torqueType;
    }

    public boolean isString() {
        return this.columnType instanceof String;
    }

    public boolean needEscapedValue() {
        return this.torqueType != null && (this.torqueType.equals("VARCHAR") || this.torqueType.equals("LONGVARCHAR") || this.torqueType.equals("DATE") || this.torqueType.equals("DATETIME") || this.torqueType.equals("TIMESTAMP") || this.torqueType.equals("CHAR"));
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("    <column name=\"").append(this.name).append('\"');
        if (this.javaName != null) {
            result.append(" javaName=\"").append(this.javaName).append('\"');
        }
        if (this.isPrimaryKey) {
            result.append(" primaryKey=\"").append(this.isPrimaryKey).append('\"');
        }
        if (this.isNotNull) {
            result.append(" required=\"true\"");
        } else {
            result.append(" required=\"false\"");
        }
        result.append(" type=\"").append(this.torqueType).append('\"');
        if (this.size != null) {
            result.append(" size=\"").append(this.size).append('\"');
        }
        if (this.defaultValue != null) {
            result.append(" default=\"").append(this.defaultValue).append('\"');
        }
        if (this.isInheritance()) {
            result.append(" inheritance=\"").append(this.inheritanceType).append('\"');
        }
        result.append(" />\n");
        return result.toString();
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String newSize) {
        this.size = newSize;
    }

    public String printSize() {
        return this.size == null ? "" : '(' + this.size + ')';
    }

    public String getDefaultSetting() {
        StringBuffer dflt = new StringBuffer(0);
        if (this.defaultValue != null) {
            dflt.append("default ");
            if (TypeMap.isTextType(this.torqueType)) {
                dflt.append('\'').append(this.defaultValue).append('\'');
            } else {
                dflt.append(this.defaultValue);
            }
        }
        return dflt.toString();
    }

    public void setDefaultValue(String def) {
        this.defaultValue = def;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getInputValidator() {
        return this.inputValidator;
    }

    public boolean isAutoIncrement() {
        return this.isAutoIncrement;
    }

    public void setAutoIncrement(boolean value) {
        this.isAutoIncrement = value;
    }

    public void setTypeFromString(String typeName, String size) {
        String tn = typeName.toUpperCase();
        this.setType(tn);
        if (size != null) {
            this.size = size;
        }
        if (tn.indexOf("CHAR") != -1) {
            this.torqueType = "VARCHAR";
            this.columnType = "";
        } else if (tn.indexOf("INT") != -1) {
            this.torqueType = "INTEGER";
            this.columnType = new Integer(0);
        } else if (tn.indexOf("FLOAT") != -1) {
            this.torqueType = "FLOAT";
            this.columnType = new Float(0.0f);
        } else if (tn.indexOf("DATE") != -1) {
            this.torqueType = "DATE";
            this.columnType = new Date();
        } else if (tn.indexOf("TIME") != -1) {
            this.torqueType = "TIMESTAMP";
            this.columnType = new Date();
        } else if (tn.indexOf("BINARY") != -1) {
            this.torqueType = "LONGVARBINARY";
            this.columnType = new Hashtable();
        } else {
            this.torqueType = "VARCHAR";
            this.columnType = "";
        }
    }

    public String getJavaObject() {
        return TypeMap.getJavaObject(this.torqueType);
    }

    public String getJavaPrimitive() {
        return TypeMap.getJavaNative(this.torqueType);
    }

    public String getJavaNative() {
        String jtype = TypeMap.getJavaNativeObject(this.torqueType);
        if (this.isUsePrimitive()) {
            jtype = TypeMap.getJavaNative(this.torqueType);
        }
        return jtype;
    }

    public String getVillageMethod() {
        String vmethod = TypeMap.getVillageObjectMethod(this.torqueType);
        if (this.isUsePrimitive()) {
            vmethod = TypeMap.getVillageMethod(this.torqueType);
        }
        return vmethod;
    }

    public String getParameterParserMethod() {
        return TypeMap.getPPMethod(this.torqueType);
    }

    public boolean isBooleanInt() {
        return TypeMap.isBooleanInt(this.torqueType);
    }

    public boolean isBooleanChar() {
        return TypeMap.isBooleanChar(this.torqueType);
    }

    public boolean isPrimitive() {
        String t = this.getJavaNative();
        return "boolean".equals(t) || "byte".equals(t) || "short".equals(t) || "int".equals(t) || "long".equals(t) || "float".equals(t) || "double".equals(t) || "char".equals(t);
    }

    public boolean isUsePrimitive() {
        String s = this.getJavaType();
        return s != null && s.equals("primitive") || s == null && !"object".equals(this.getTable().getDatabase().getDefaultJavaType());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

