/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.model;

import org.apache.commons.lang.ArrayUtils;
import org.asyrinx.joey.gen.model.IFieldType;
import org.asyrinx.joey.gen.model.IProperty;
import org.asyrinx.joey.gen.model.WmEnum;

public class FieldTypeImpl
implements IFieldType {
    private final IProperty property;
    private static final String[] TYPE_TEXT_FIELDS = new String[]{"CHAR", "VARCHAR"};
    private static final String[] TYPE_MEMO_FIELDS = new String[]{"LONGVARCHAR", "CLOB"};
    private static final String[] TYPE_DATE_FIELDS = new String[]{"DATE", "TIME", "TIMESTAMP"};
    private static final String[] TYPE_BOOLEAN_FIELDS = new String[]{"BIT"};
    private static final String[] TYPE_NUMBER_FIELDS = new String[]{"NUMERIC", "DECIMAL", "TINYINT", "SMALLINT", "INTEGER", "BIGINT", "REAL", "FLOAT", "DOUBLE"};

    public FieldTypeImpl(IProperty property) {
        this.property = property;
    }

    private Object getTorqueType() {
        return this.property.getTorqueType();
    }

    private WmEnum getEnum() {
        return this.property.getEnum();
    }

    public boolean isTextFieldType() {
        return ArrayUtils.indexOf((Object[])TYPE_TEXT_FIELDS, (Object)this.getTorqueType()) > -1;
    }

    public boolean isMemoFieldType() {
        return ArrayUtils.indexOf((Object[])TYPE_MEMO_FIELDS, (Object)this.getTorqueType()) > -1;
    }

    public boolean isBooleanFieldType() {
        return ArrayUtils.indexOf((Object[])TYPE_BOOLEAN_FIELDS, (Object)this.getTorqueType()) > -1;
    }

    public boolean isDateFieldType() {
        return ArrayUtils.indexOf((Object[])TYPE_DATE_FIELDS, (Object)this.getTorqueType()) > -1;
    }

    public boolean isNumberFieldType() {
        return ArrayUtils.indexOf((Object[])TYPE_NUMBER_FIELDS, (Object)this.getTorqueType()) > -1;
    }

    public boolean isSelectFieldType() {
        return this.getEnum() != null;
    }
}

