/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.torque.engine.database.model.TypeMap;

public class TypeNameUtils
extends TypeMap {
    private static Map mapTorqueToHibernateType = TypeNameUtils.newMapTorqueToHibernateType();
    private static Map mapJavaPrimitiveToClass = TypeNameUtils.newJavaTypeMap();
    private static final String BIT_NATIVE_TYPE = "boolean";
    private static final String TINYINT_NATIVE_TYPE = "byte";
    private static final String SMALLINT_NATIVE_TYPE = "short";
    private static final String INTEGER_NATIVE_TYPE = "int";
    private static final String BIGINT_NATIVE_TYPE = "long";
    private static final String REAL_NATIVE_TYPE = "float";
    private static final String FLOAT_NATIVE_TYPE = "double";
    private static final String DOUBLE_NATIVE_TYPE = "double";
    private static final String BINARY_NATIVE_TYPE = "byte[]";
    private static final String VARBINARY_NATIVE_TYPE = "byte[]";
    private static final String LONGVARBINARY_NATIVE_TYPE = "byte[]";
    private static final String BLOB_NATIVE_TYPE = "byte[]";
    private static final String BOOLEANCHAR_NATIVE_TYPE = "boolean";
    private static final String BOOLEANINT_NATIVE_TYPE = "boolean";
    private static final String BIT_JAVA_CLASS = "Boolean";
    private static final String TINYINT_JAVA_CLASS = "Byte";
    private static final String SMALLINT_JAVA_CLASS = "Short";
    private static final String INTEGER_JAVA_CLASS = "Integer";
    private static final String BIGINT_JAVA_CLASS = "Long";
    private static final String REAL_JAVA_CLASS = "Float";
    private static final String FLOAT_JAVA_CLASS = "Double";
    private static final String DOUBLE_JAVA_CLASS = "Double";
    private static final String BINARY_JAVA_CLASS = "Byte[]";
    private static final String VARBINARY_JAVA_CLASS = "Byte[]";
    private static final String LONGVARBINARY_JAVA_CLASS = "Byte[]";
    private static final String BLOB_JAVA_CLASS = "Byte[]";
    private static final String BOOLEANCHAR_JAVA_CLASS = "Boolean";
    private static final String BOOLEANINT_JAVA_CLASS = "Boolean";

    public static String toJavaNativeType(String torqueType) {
        return TypeMap.getJavaNative((String)TypeMap.getJdbcType((String)torqueType));
    }

    public static String toClassName(String primitiveTypeName) {
        String result = (String)mapJavaPrimitiveToClass.get(primitiveTypeName);
        if (result != null) {
            return result;
        }
        return primitiveTypeName;
    }

    public static String torqueToHibernateType(String torqueType) {
        return (String)mapTorqueToHibernateType.get(torqueType);
    }

    private static final synchronized Map newMapTorqueToHibernateType() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("CHAR", "character");
        result.put("VARCHAR", "string");
        result.put("LONGVARCHAR", "string");
        result.put("NUMERIC", "big_decimal");
        result.put("DECIMAL", "big_decimal");
        result.put("BIT", "boolean");
        result.put("TINYINT", TINYINT_NATIVE_TYPE);
        result.put("SMALLINT", SMALLINT_NATIVE_TYPE);
        result.put("INTEGER", "integer");
        result.put("BIGINT", BIGINT_NATIVE_TYPE);
        result.put("REAL", REAL_NATIVE_TYPE);
        result.put("FLOAT", "double");
        result.put("DOUBLE", "double");
        result.put("BINARY", "binary");
        result.put("VARBINARY", "binary");
        result.put("LONGVARBINARY", "binary");
        result.put("DATE", "date");
        result.put("TIME", "time");
        result.put("TIMESTAMP", "timestamp");
        result.put("BLOB", "blob");
        result.put("CLOB", "clob");
        return result;
    }

    private static final synchronized Map newJavaTypeMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("boolean", "Boolean");
        result.put(TINYINT_NATIVE_TYPE, TINYINT_JAVA_CLASS);
        result.put(SMALLINT_NATIVE_TYPE, SMALLINT_JAVA_CLASS);
        result.put(INTEGER_NATIVE_TYPE, INTEGER_JAVA_CLASS);
        result.put(BIGINT_NATIVE_TYPE, BIGINT_JAVA_CLASS);
        result.put(REAL_NATIVE_TYPE, REAL_JAVA_CLASS);
        result.put("double", "Double");
        result.put("double", "Double");
        result.put("byte[]", "Byte[]");
        result.put("byte[]", "Byte[]");
        result.put("byte[]", "Byte[]");
        result.put("byte[]", "Byte[]");
        result.put("boolean", "Boolean");
        result.put("boolean", "Boolean");
        return result;
    }
}

