/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.model.visitor;

import java.util.Iterator;
import org.apache.commons.collections.IteratorUtils;
import org.asyrinx.joey.gen.model.IVisitor;
import org.asyrinx.joey.gen.model.WmAppData;
import org.asyrinx.joey.gen.model.WmAspect;
import org.asyrinx.joey.gen.model.WmAspectAction;
import org.asyrinx.joey.gen.model.WmAspectRef;
import org.asyrinx.joey.gen.model.WmColumn;
import org.asyrinx.joey.gen.model.WmColumnFormat;
import org.asyrinx.joey.gen.model.WmDatabase;
import org.asyrinx.joey.gen.model.WmEnum;
import org.asyrinx.joey.gen.model.WmEnumEntry;
import org.asyrinx.joey.gen.model.WmForeignKey;
import org.asyrinx.joey.gen.model.WmIdMethodParameter;
import org.asyrinx.joey.gen.model.WmIndex;
import org.asyrinx.joey.gen.model.WmInheritance;
import org.asyrinx.joey.gen.model.WmJoin;
import org.asyrinx.joey.gen.model.WmProperty;
import org.asyrinx.joey.gen.model.WmTable;
import org.asyrinx.joey.gen.model.WmTableAspect;
import org.asyrinx.joey.gen.model.WmUnique;
import org.asyrinx.joey.gen.model.visitor.VisitorWrapper;

public class TopDownVisitor
extends VisitorWrapper {
    public TopDownVisitor(IVisitor wrapped) {
        super(wrapped);
    }

    public void visit(WmAppData appData) {
        super.visit(appData);
        Iterator iterator = appData.getDbIterator();
        while (iterator.hasNext()) {
            WmDatabase database = (WmDatabase)iterator.next();
            database.accept(this);
        }
    }

    public void visit(WmAspect aspect) {
        super.visit(aspect);
        Iterator iterator = aspect.getActions().iterator();
        while (iterator.hasNext()) {
            WmAspectAction action = (WmAspectAction)iterator.next();
            action.accept(this);
        }
    }

    public void visit(WmAspectAction aspectAction) {
        super.visit(aspectAction);
    }

    public void visit(WmAspectRef aspectRef) {
        super.visit(aspectRef);
    }

    public void visit(WmColumn column) {
        super.visit(column);
        if (column.getAdditional() != null) {
            column.getAdditional().accept(this);
        }
        if (column.getFormat() != null) {
            column.getFormat().accept(this);
        }
    }

    public void visit(WmColumnFormat format) {
        super.visit(format);
    }

    public void visit(WmDatabase database) {
        super.visit(database);
        Iterator tableIter = IteratorUtils.arrayIterator((Object[])database.getTables());
        while (tableIter.hasNext()) {
            WmTable table = (WmTable)tableIter.next();
            table.accept(this);
        }
        Iterator tableAspectIter = database.getTableAspects().iterator();
        while (tableAspectIter.hasNext()) {
            WmTableAspect tableAspect = (WmTableAspect)tableAspectIter.next();
            tableAspect.accept(this);
        }
        Iterator aspectIter = database.getAspects().iterator();
        while (aspectIter.hasNext()) {
            WmAspect aspect = (WmAspect)aspectIter.next();
            aspect.accept(this);
        }
        Iterator enumIter = database.getEnums().iterator();
        while (enumIter.hasNext()) {
            WmEnum wmEnum = (WmEnum)enumIter.next();
            wmEnum.accept(this);
        }
    }

    public void visit(WmEnum wmEnum) {
        super.visit(wmEnum);
        Iterator iterator = wmEnum.getEntries().iterator();
        while (iterator.hasNext()) {
            WmEnumEntry entry = (WmEnumEntry)iterator.next();
            entry.accept(this);
        }
    }

    public void visit(WmEnumEntry enumEntry) {
        super.visit(enumEntry);
    }

    public void visit(WmForeignKey foreignKey) {
        super.visit(foreignKey);
    }

    public void visit(WmIdMethodParameter idMethodParameter) {
        super.visit(idMethodParameter);
    }

    public void visit(WmIndex index) {
        super.visit(index);
    }

    public void visit(WmInheritance inheritance) {
        super.visit(inheritance);
    }

    public void visit(WmJoin join) {
        super.visit(join);
        Iterator iterator = join.getChildren().iterator();
        while (iterator.hasNext()) {
            WmJoin child = (WmJoin)iterator.next();
            child.accept(this);
        }
    }

    public void visit(WmProperty property) {
        super.visit(property);
    }

    public void visit(WmTable table) {
        super.visit(table);
        this.visitTableImpl(table);
    }

    private void visitTableImpl(WmTable table) {
        Iterator colIter = IteratorUtils.arrayIterator((Object[])table.getColumns());
        while (colIter.hasNext()) {
            WmColumn col = (WmColumn)colIter.next();
            col.accept(this);
        }
        Iterator fkIter = IteratorUtils.arrayIterator((Object[])table.getForeignKeys());
        while (fkIter.hasNext()) {
            WmForeignKey foreignKey = (WmForeignKey)fkIter.next();
            foreignKey.accept(this);
        }
        Iterator idxIter = IteratorUtils.arrayIterator((Object[])table.getIndices());
        while (idxIter.hasNext()) {
            WmIndex index = (WmIndex)idxIter.next();
            index.accept(this);
        }
        Iterator uniqIter = IteratorUtils.arrayIterator((Object[])table.getUnices());
        while (uniqIter.hasNext()) {
            WmUnique unique = (WmUnique)uniqIter.next();
            unique.accept(this);
        }
        if (table.getIdMethodParameters() != null) {
            Iterator idMethodIter = table.getIdMethodParameters().iterator();
            while (idMethodIter.hasNext()) {
                WmIdMethodParameter parameter = (WmIdMethodParameter)idMethodIter.next();
                parameter.accept(this);
            }
        }
        Iterator refIter = table.getAspectRefs().iterator();
        while (refIter.hasNext()) {
            WmAspectRef aspectRef = (WmAspectRef)refIter.next();
            aspectRef.accept(this);
        }
        Iterator joinIter = table.getJoins().iterator();
        while (joinIter.hasNext()) {
            WmJoin join = (WmJoin)joinIter.next();
            join.accept(this);
        }
    }

    public void visit(WmTableAspect tableAspect) {
        super.visit(tableAspect);
        this.visitTableImpl(tableAspect);
    }

    public void visit(WmUnique unique) {
        super.visit(unique);
    }
}

