/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.task;

import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.torque.engine.EngineException;
import org.apache.velocity.context.Context;
import org.asyrinx.joey.gen.model.TypeNameUtils;
import org.asyrinx.joey.gen.model.WmAppData;
import org.asyrinx.joey.gen.model.WmDatabase;
import org.asyrinx.joey.gen.model.WmTable;
import org.asyrinx.joey.gen.model.xml.AppDataBuilder;
import org.asyrinx.joey.gen.options.OmType;
import org.asyrinx.joey.gen.task.BaseJoeyDataModelTask;
import org.asyrinx.joey.gen.task.PageGeneratingHelper;
import org.xml.sax.SAXException;

public class JoeyDataModelTask
extends BaseJoeyDataModelTask {
    protected final PageGeneratingHelper pageGenerator = new PageGeneratingHelper();

    protected void addNewAppData(String fileName) throws EngineException {
        AppDataBuilder builder = new AppDataBuilder(this.getTargetDatabase(), this.getTargetPackage(), this.getBasePathToDbProps());
        try {
            WmAppData ad = builder.execute(fileName);
            ad.setName(String.valueOf(this.getContextProperties().getProperty("torque.project")));
            this.combine(ad);
        }
        catch (IOException e) {
            throw new EngineException((Throwable)e);
        }
        catch (SAXException e) {
            throw new EngineException((Throwable)e);
        }
    }

    private void combine(WmAppData newAppData) {
        if (this.dataModels.isEmpty()) {
            this.dataModels.add(newAppData);
            return;
        }
        WmAppData oldAppData = (WmAppData)this.dataModels.get(0);
        Iterator dbIter = newAppData.getDbIterator();
        while (dbIter.hasNext()) {
            WmDatabase newAppDataDb = (WmDatabase)dbIter.next();
            WmDatabase oldDb = oldAppData.find(newAppDataDb.getName());
            if (oldDb == null) {
                oldAppData.addDatabase(newAppDataDb);
                continue;
            }
            Iterator tableIter = IteratorUtils.arrayIterator((Object[])newAppDataDb.getTables());
            while (tableIter.hasNext()) {
                WmTable newTable = (WmTable)tableIter.next();
                if (oldDb.getTable(newTable.getName()) != null) continue;
                oldDb.addTable(newTable);
            }
        }
    }

    public Context initControlContext() throws Exception {
        Context result = super.initControlContext();
        result.put("omTypeObj", (Object)OmType.findOmType(result.get("omType")));
        result.put("helper", (Object)new PageGeneratingHelper());
        result.put("stringUtils", (Object)new StringUtils());
        result.put("typeNameUtils", (Object)new TypeNameUtils());
        return result;
    }
}

