/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.joey.gen.task;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Iterator;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.torque.engine.EngineException;
import org.apache.torque.engine.database.model.AppData;
import org.apache.torque.engine.database.transform.XmlToAppData;
import org.apache.velocity.context.Context;
import org.asyrinx.joey.gen.task.JoeyDataModelTask;

public class JoeySQLTask
extends JoeyDataModelTask {
    private String database;
    private String suffix = "";
    private String idTableXMLFile = null;

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setIdTableXMLFile(String idXmlFile) {
        this.idTableXMLFile = idXmlFile;
    }

    public String getIdTableXMLFile() {
        return this.idTableXMLFile;
    }

    private void createSqlDbMap() throws Exception {
        if (this.getSqlDbMap() == null) {
            return;
        }
        Properties sqldbmap = new Properties();
        File file = new File(this.getSqlDbMap());
        if (file.exists()) {
            FileInputStream fis = new FileInputStream(file);
            sqldbmap.load(fis);
            fis.close();
        }
        Iterator i = this.getDataModelDbMap().keySet().iterator();
        while (i.hasNext()) {
            String dataModelName = (String)i.next();
            String sqlFile = String.valueOf(dataModelName) + this.suffix + ".sql";
            String databaseName = this.getDatabase() == null ? (String)this.getDataModelDbMap().get(dataModelName) : this.getDatabase();
            sqldbmap.setProperty(sqlFile, databaseName);
        }
        sqldbmap.store(new FileOutputStream(this.getSqlDbMap()), "Sqlfile -> Database map");
    }

    public void loadIdBrokerModel() throws EngineException {
        XmlToAppData xmlParser = new XmlToAppData(this.getTargetDatabase(), null, this.getBasePathToDbProps());
        AppData ad = xmlParser.parseFile(this.getIdTableXMLFile());
        ad.setName("idmodel");
        this.context.put("idmodel", (Object)ad);
    }

    public Context initControlContext() throws Exception {
        super.initControlContext();
        try {
            this.createSqlDbMap();
            String f = this.getIdTableXMLFile();
            if (f != null && f.length() > 0) {
                this.loadIdBrokerModel();
            }
        }
        catch (EngineException ee) {
            throw new BuildException((Throwable)ee);
        }
        return this.context;
    }
}

