/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.om;

import java.math.BigDecimal;
import org.apache.torque.om.SimpleKey;

public class NumberKey
extends SimpleKey {
    public NumberKey() {
    }

    public NumberKey(String key) {
        this.key = new BigDecimal(key);
    }

    public NumberKey(BigDecimal key) {
        this.key = key;
    }

    public NumberKey(NumberKey key) {
        this.key = key != null ? key.getValue() : null;
    }

    public NumberKey(long key) {
        this.key = new BigDecimal((double)key);
    }

    public NumberKey(double key) {
        this.key = new BigDecimal(key);
    }

    public NumberKey(int key) {
        this((long)key);
    }

    public NumberKey(Number key) {
        this.key = key != null ? new BigDecimal(key.toString()) : null;
    }

    public void setValue(String key) throws NumberFormatException {
        this.key = new BigDecimal(key);
    }

    public void setValue(BigDecimal key) {
        this.key = key;
    }

    public void setValue(NumberKey key) {
        this.key = key == null ? null : key.getValue();
    }

    public BigDecimal getBigDecimal() {
        return (BigDecimal)this.key;
    }

    public boolean equals(Object keyObj) {
        if (keyObj == this) {
            return true;
        }
        if (!(keyObj instanceof NumberKey)) {
            if (keyObj instanceof String) {
                throw new IllegalArgumentException("NumberKeys are not comparable to Strings");
            }
            return false;
        }
        if (this.getValue() != null) {
            return this.getValue().equals(((NumberKey)keyObj).getValue());
        }
        return false;
    }

    public int hashCode() {
        if (this.getValue() == null) {
            return super.hashCode();
        }
        return this.getValue().hashCode();
    }

    public int compareTo(Object o) {
        return this.getBigDecimal().compareTo(((NumberKey)o).getBigDecimal());
    }

    public String toString() {
        if (this.key != null) {
            return this.key.toString();
        }
        return "";
    }

    public byte byteValue() {
        return this.getBigDecimal().byteValue();
    }

    public int intValue() {
        return this.getBigDecimal().intValue();
    }

    public short shortValue() {
        return this.getBigDecimal().shortValue();
    }

    public long longValue() {
        return this.getBigDecimal().longValue();
    }

    public float floatValue() {
        return this.getBigDecimal().floatValue();
    }

    public double doubleValue() {
        return this.getBigDecimal().doubleValue();
    }
}

