/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.collection;

import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.asyrinx.brownie.core.collection.MapTreeVisitor;
import org.asyrinx.brownie.core.lang.ArrayUtils;
import org.asyrinx.brownie.core.lang.StringUtils;

public class MapTree {
    protected final Map root;
    private String keyDelimiter = ".";

    public MapTree() {
        this(new HashMap());
    }

    public MapTree(Map root) {
        this.root = root;
    }

    public MapTree(MapTree mapTree) {
        this(mapTree.getRoot());
    }

    protected Object[] toKeys(Object key) {
        String keyStr = String.valueOf(key);
        return StringUtils.tokenizeToArray(keyStr, this.keyDelimiter);
    }

    public void put(Object key, Object value) {
        if (key instanceof Object[]) {
            this.put((Object[])key, value);
        } else {
            this.put(this.toKeys(key), value);
        }
    }

    public Object get(Object key) {
        if (key instanceof Object[]) {
            return this.get((Object[])key);
        }
        return this.get(this.toKeys(key));
    }

    public void put(Object[] key, Object value) {
        if (key == null || key.length == 0) {
            return;
        }
        Map map = key.length == 1 ? this.root : this.needMap(ArrayUtils.subArray(key, 0, key.length - 1));
        map.put(key[key.length - 1], value);
    }

    public Object get(Object[] keys) {
        if (keys == null || keys.length == 0) {
            return null;
        }
        Map map = keys.length == 1 ? this.root : this.getMap(ArrayUtils.subArray(keys, 0, keys.length - 1));
        return map == null ? null : map.get(keys[keys.length - 1]);
    }

    public Map getRoot() {
        return this.root;
    }

    public Map getMap(Object key) {
        if (key instanceof Object[]) {
            return this.getMap((Object[])key);
        }
        return this.getMap(this.toKeys(key));
    }

    protected Map getMap(Object[] keys) {
        Map current = this.root;
        int i = 0;
        while (i < keys.length) {
            Object val = current.get(keys[i]);
            if (!(val instanceof Map)) {
                return null;
            }
            current = (Map)val;
            ++i;
        }
        return current;
    }

    protected Map needMap(Object[] keys) {
        Map current = this.root;
        int i = 0;
        while (i < keys.length) {
            Object val = current.get(keys[i]);
            if (val instanceof Map) {
                current = (Map)val;
            } else {
                Map newMap = this.createMap();
                current.put(keys[i], newMap);
                current = newMap;
            }
            ++i;
        }
        return current;
    }

    protected Map createMap() {
        return new HashMap();
    }

    public String getKeyDelimiter() {
        return this.keyDelimiter;
    }

    public void setKeyDelimiter(String string) {
        this.keyDelimiter = string;
    }

    public void saveTo(Properties properties) {
        final Properties props = properties;
        MapTreeVisitor visitor = new MapTreeVisitor(this.root){

            public void doOnLeaf(Object value) {
                String key = StringUtils.connectString((Collection)this.keyStack, MapTree.this.keyDelimiter);
                ((Hashtable)props).put(key, value);
            }
        };
        visitor.execute();
    }

    public void loadFrom(Properties properties) {
        Iterator iterator = ((Hashtable)properties).keySet().iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            this.put(key, ((Hashtable)properties).get(key));
        }
    }
}

