/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.log;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;

public abstract class LogLevel {
    private final int value;
    private final String name;
    private static final Set levels = new HashSet();
    private static Map name2Level = new HashMap();
    public static final LogLevel TRACE = new LogLevel(0, "trace"){

        public void write(Log log, Object msg, Throwable t) {
            log.trace(msg, t);
        }
    };
    public static final LogLevel DEBUG = new LogLevel(1, "debug"){

        public void write(Log log, Object msg, Throwable t) {
            log.debug(msg, t);
        }
    };
    public static final LogLevel INFO = new LogLevel(2, "info"){

        public void write(Log log, Object msg, Throwable t) {
            log.info(msg, t);
        }
    };
    public static final LogLevel WARN = new LogLevel(3, "warn"){

        public void write(Log log, Object msg, Throwable t) {
            log.warn(msg, t);
        }
    };
    public static final LogLevel ERROR = new LogLevel(4, "error"){

        public void write(Log log, Object msg, Throwable t) {
            log.error(msg, t);
        }
    };
    public static final LogLevel FATAL = new LogLevel(5, "fatal"){

        public void write(Log log, Object msg, Throwable t) {
            log.fatal(msg, t);
        }
    };
    public static final LogLevel NONE = new LogLevel(5, "none"){

        public void write(Log log, Object msg, Throwable t) {
        }
    };

    private LogLevel(int value, String name) {
        this.name = name;
        this.value = value;
        LogLevel.register(this);
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public abstract void write(Log var1, Object var2, Throwable var3);

    public void write(Log log, Object msg) {
        this.write(log, msg, null);
    }

    public String toString() {
        return this.name;
    }

    public static Set getLevels() {
        return new HashSet(levels);
    }

    protected void finalize() throws Throwable {
        levels.remove(this);
        super.finalize();
    }

    public static void register(LogLevel level) {
        levels.add(level);
        name2Level.put(level.name, level);
    }

    public static LogLevel findByName(String name) {
        return (LogLevel)name2Level.get(name);
    }

    public static LogLevel getLevel(String name) {
        return LogLevel.findByName(name);
    }

    /* synthetic */ LogLevel(int n, String string, LogLevel logLevel) {
        this(n, string);
    }
}

