/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.sql;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.asyrinx.brownie.core.sql.BasicSqlBuilder;
import org.asyrinx.brownie.core.sql.Conditions;
import org.asyrinx.brownie.core.sql.Fields;
import org.asyrinx.brownie.core.sql.IBuilder;
import org.asyrinx.brownie.core.sql.Tables;

public class DynamicSelect {
    protected final IBuilder builder;
    private final Fields selectFields;
    private final Tables fromTables;
    private final Conditions whereConditions;
    private final Fields groupByFields;
    private final Conditions havingConditions;
    private final Fields orderByFields;
    private boolean distinct = false;
    private DateFormat dateFormat = new SimpleDateFormat("yyyy/mm/dd");

    public DynamicSelect() {
        this(new BasicSqlBuilder());
    }

    public DynamicSelect(IBuilder builder) {
        this.builder = builder;
        this.selectFields = new Fields(builder);
        this.fromTables = new Tables(builder);
        this.whereConditions = new Conditions(builder);
        this.groupByFields = new Fields(builder);
        this.havingConditions = new Conditions(builder);
        this.orderByFields = new Fields(builder);
    }

    public Conditions newConditions() {
        return new Conditions(this.builder);
    }

    public Fields newFields() {
        return new Fields(this.builder);
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat format) {
        this.dateFormat = format;
    }

    public void build(StringBuffer buffer) {
        this.builder.build(this, buffer);
    }

    public String build() {
        StringBuffer dest = new StringBuffer();
        this.build(dest);
        return dest.toString();
    }

    public void clear() {
        this.selectFields.clear();
        this.fromTables.clear();
        this.whereConditions.clear();
        this.orderByFields.clear();
        this.groupByFields.clear();
        this.havingConditions.clear();
        this.distinct = false;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean b) {
        this.distinct = b;
    }

    public Tables getFromTables() {
        return this.fromTables;
    }

    public Fields getGroupByFields() {
        return this.groupByFields;
    }

    public Conditions getHavingConditions() {
        return this.havingConditions;
    }

    public Fields getOrderByFields() {
        return this.orderByFields;
    }

    public Fields getSelectFields() {
        return this.selectFields;
    }

    public Conditions getWhereConditions() {
        return this.whereConditions;
    }
}

