/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.sql2;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections.IteratorUtils;
import org.asyrinx.brownie.core.lang.ArrayUtils;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.brownie.core.sql.Operator;
import org.asyrinx.brownie.core.sql2.Condition;
import org.asyrinx.brownie.core.sql2.Conditions;
import org.asyrinx.brownie.core.sql2.Field;
import org.asyrinx.brownie.core.sql2.Fields;
import org.asyrinx.brownie.core.sql2.Select;
import org.asyrinx.brownie.core.sql2.SqlBuilder;
import org.asyrinx.brownie.core.sql2.Table;
import org.asyrinx.brownie.core.sql2.Tables;
import org.asyrinx.brownie.core.sql2.Visitor;

public class BasicSqlBuilder
implements Visitor,
SqlBuilder {
    private StringBuffer result = null;
    private StringBuffer work = null;

    public String toSql(Select select) {
        select.accept(this);
        return this.result.toString();
    }

    public void visit(Select select) {
        this.result = new StringBuffer();
        this.work = new StringBuffer();
        select.getSelectFields().accept(this);
        if (this.work.length() > 0) {
            this.result.append("select ");
            if (select.isDistinct()) {
                this.result.append("distinct ");
            }
            this.result.append(this.work);
        }
        this.work = new StringBuffer();
        select.getFromTables().accept(this);
        if (this.work.length() > 0) {
            if (this.result.length() > 0) {
                this.result.append(" ");
            }
            this.result.append("from ");
            this.result.append(this.work);
        }
        this.work = new StringBuffer();
        select.getWhereConditions().accept(this);
        if (this.work.length() > 0) {
            if (this.result.length() > 0) {
                this.result.append(" ");
            }
            this.result.append("where ");
            this.result.append(this.work);
        }
        this.work = new StringBuffer();
        select.getGroupByFields().accept(this);
        if (this.work.length() > 0) {
            if (this.result.length() > 0) {
                this.result.append(" ");
            }
            this.result.append("group by ");
            this.result.append(this.work);
        }
        this.work = new StringBuffer();
        select.getHavingConditions().accept(this);
        if (this.work.length() > 0) {
            if (this.result.length() > 0) {
                this.result.append(" ");
            }
            this.result.append("having ");
            this.result.append(this.work);
        }
        this.work = new StringBuffer();
        select.getOrderByFields().accept(this);
        if (this.work.length() > 0) {
            if (this.result.length() > 0) {
                this.result.append(" ");
            }
            this.result.append("order by ");
            this.result.append(this.work);
        }
    }

    protected String toString(Object value) {
        if (value instanceof String) {
            return StringUtils.toQuoted((String)value, '\'');
        }
        if (value instanceof Character) {
            return StringUtils.toQuoted((Character)value + "", '\'');
        }
        if (value.getClass().isArray()) {
            if (value.getClass().getComponentType().isPrimitive()) {
                return this.toString(IteratorUtils.arrayIterator((Object[])ArrayUtils.toObjectArray(value)));
            }
            return this.toString(IteratorUtils.arrayIterator((Object[])((Object[])value)));
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (collection.isEmpty()) {
                return null;
            }
            return this.toString(((Collection)value).iterator());
        }
        if (value instanceof Iterator) {
            return this.toString((Iterator)value);
        }
        return String.valueOf(value);
    }

    protected String toString(Iterator iterator) {
        boolean isFirst = true;
        StringBuffer buf = new StringBuffer();
        while (iterator.hasNext()) {
            if (isFirst) {
                isFirst = false;
            } else {
                buf.append(", ");
            }
            Object value = iterator.next();
            buf.append(this.toString(value));
        }
        String res = buf.toString();
        if ("".equals(res)) {
            return null;
        }
        return res;
    }

    public void visit(Condition condition) {
        String value = this.toString(condition.getValue());
        if (value == null) {
            return;
        }
        if (this.work.length() > 0) {
            this.work.append(" ").append(condition.getConnection()).append(" ");
        }
        if (org.apache.commons.lang.StringUtils.isNotEmpty((String)condition.getFieldName())) {
            this.work.append(condition.getFieldName()).append(" ");
        }
        this.work.append(condition.getOperator()).append(" ");
        if (condition.getOperator() == Operator.IN) {
            this.work.append("(");
        }
        this.work.append(value);
        if (condition.getOperator() == Operator.IN) {
            this.work.append(")");
        }
    }

    public void visit(Conditions conditions) {
        Iterator iterator = conditions.iterator();
        while (iterator.hasNext()) {
            Object var5_5;
            Object object = iterator.next();
            if (object instanceof Condition) {
                ((Condition)object).accept(this);
                continue;
            }
            if (!(object instanceof Conditions)) continue;
            StringBuffer workBakup = this.work;
            this.work = new StringBuffer();
            try {
                ((Conditions)object).accept(this);
            }
            catch (Throwable throwable) {
                var5_5 = null;
                if (this.work.length() > 0) {
                    if (workBakup.length() > 0) {
                        workBakup.append(" ").append(conditions.getConnection()).append(" ");
                    }
                    workBakup.append("(");
                    workBakup.append(this.work);
                    workBakup.append(")");
                }
                this.work = workBakup;
                throw throwable;
            }
            var5_5 = null;
            if (this.work.length() > 0) {
                if (workBakup.length() > 0) {
                    workBakup.append(" ").append(conditions.getConnection()).append(" ");
                }
                workBakup.append("(");
                workBakup.append(this.work);
                workBakup.append(")");
            }
            this.work = workBakup;
        }
    }

    public void visit(Field field) {
        if (org.apache.commons.lang.StringUtils.isNotEmpty((String)field.getFunctionName())) {
            this.work.append(field.getFunctionName()).append("(");
        }
        if (org.apache.commons.lang.StringUtils.isNotEmpty((String)field.getTableAlias())) {
            this.work.append(field.getTableAlias()).append(".");
        }
        this.work.append(field.getFieldName());
        if (org.apache.commons.lang.StringUtils.isNotEmpty((String)field.getFunctionName())) {
            this.work.append(")");
        }
        if (org.apache.commons.lang.StringUtils.isNotEmpty((String)field.getAliasName())) {
            this.work.append(" as ").append(field.getAliasName());
        }
    }

    public void visit(Fields fields) {
        boolean isFirst = true;
        Iterator iterator = fields.iterator();
        while (iterator.hasNext()) {
            if (!isFirst) {
                this.work.append(", ");
            } else {
                isFirst = false;
            }
            Object object = iterator.next();
            if (object instanceof Field) {
                ((Field)object).accept(this);
                continue;
            }
            if (!(object instanceof Fields)) continue;
            ((Fields)object).accept(this);
        }
    }

    public void visit(Table table) {
        if (org.apache.commons.lang.StringUtils.isNotEmpty((String)table.getTablePrefix())) {
            this.work.append(table.getTablePrefix()).append(".");
        }
        this.work.append(table.getTableName());
        if (org.apache.commons.lang.StringUtils.isNotEmpty((String)table.getTableAlias())) {
            this.work.append(" as ").append(table.getTableAlias());
        }
        if (org.apache.commons.lang.StringUtils.isNotEmpty((String)table.getIndexName())) {
            this.work.append("(INDEX ").append(table.getIndexName()).append(")");
        }
    }

    public void visit(Tables tables) {
        boolean isFirst = true;
        Iterator iterator = tables.iterator();
        while (iterator.hasNext()) {
            if (!isFirst) {
                this.work.append(", ");
            } else {
                isFirst = false;
            }
            Object object = iterator.next();
            if (object instanceof Table) {
                ((Table)object).accept(this);
                continue;
            }
            if (!(object instanceof Tables)) continue;
            ((Tables)object).accept(this);
        }
    }
}

