/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util.regexp;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.util.regexp.RegexpMatcher;

public class RegexpMatcherFactory {
    public RegexpMatcher newRegexpMatcher() throws BuildException {
        return this.newRegexpMatcher(null);
    }

    public RegexpMatcher newRegexpMatcher(Project p) throws BuildException {
        String systemDefault = null;
        systemDefault = p == null ? System.getProperty("ant.regexp.regexpimpl") : p.getProperty("ant.regexp.regexpimpl");
        if (systemDefault != null) {
            return this.createInstance(systemDefault);
        }
        try {
            this.testAvailability("java.util.regex.Matcher");
            return this.createInstance("org.apache.tools.ant.util.regexp.Jdk14RegexpMatcher");
        }
        catch (BuildException be) {
            try {
                this.testAvailability("org.apache.oro.text.regex.Pattern");
                return this.createInstance("org.apache.tools.ant.util.regexp.JakartaOroMatcher");
            }
            catch (BuildException be2) {
                try {
                    this.testAvailability("org.apache.regexp.RE");
                    return this.createInstance("org.apache.tools.ant.util.regexp.JakartaRegexpMatcher");
                }
                catch (BuildException be3) {
                    throw new BuildException("No supported regular expression matcher found");
                }
            }
        }
    }

    protected RegexpMatcher createInstance(String className) throws BuildException {
        try {
            Class<?> implClass = Class.forName(className);
            return (RegexpMatcher)implClass.newInstance();
        }
        catch (Throwable t) {
            throw new BuildException(t);
        }
    }

    protected void testAvailability(String className) throws BuildException {
        try {
            Class<?> implClass = Class.forName(className);
        }
        catch (Throwable t) {
            throw new BuildException(t);
        }
    }
}

